% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRadar.R
\name{plotRadar}
\alias{plotRadar}
\title{plotRadar()}
\usage{
plotRadar(
  data,
  pattern,
  group,
  max = 0.6,
  min = 0,
  method = "median",
  axislabcol = "grey",
  plwd = 2,
  plty = 1,
  cglcol = 1,
  seg = 4,
  cglwd = 1,
  cglty = 3,
  vlcex = 1,
  axistype = 1,
  t.size = 15,
  t.vjust = 0,
  t.color = "black",
  l.postion = "topright",
  l.bty = "n",
  lt.col = "grey25",
  lt.cex = 2,
  l.cex = 1
)
}
\arguments{
\item{data}{A dataframe storing absolute concentration or PL% of lipids between different samples. If not, use cleanXpert() or noridx.output() + normalization.calculator()
to get normalized data.
The column name should be the sample name and the row name should be the lipid type.
The class of column name and row name should be "character". The class of values should be
"numeric". The row names are recommended to be in a form like "PL(14:0/20:1)" or "LPL(16:1)".}

\item{pattern}{Can accept 4 values: "lipid", "CB", "sat", or "all"

    If pattern="lipid“, a new radar diagram based on lipid type will be saved, which was named as "lipid_RadarChart.pdf"

    If pattern="CB“, a new radar diagram based on carbon number will be saved, which was named as "carbon_number_RadarChart.pdf"

    If pattern="sat“, a new radar diagram based on the number of double bonds will be saved, which was named as "unsaturation_RadarChart.pdf"

    If pattern="all“, all three diagrams will be saved.}

\item{group}{A vector defining which group the replicates belong to. Notice: the number of groups should be less than 17.}

\item{max}{The maximal absolute concentration or PL\% values of each class. The default value is 0.6.}

\item{min}{The minimal absolute concentration or PL\% values of each class. The default value is 0.}

\item{method}{The method to select the representative value from a group, which can be "median" or "mean".
If it equals "median", the median of the group samples will be chosen. Otherwise, the mean will be chosen to plot.}

\item{axislabcol}{The color of axis, default value is "grey".}

\item{plwd}{Defines the width of the data series line. Default value is 2.}

\item{plty}{Specifies the style of the data series line, which can be 1-6. Default value is 1.}

\item{cglcol}{Specifies the color of the gridlines. Default value is 1.}

\item{seg}{Defines the number of gridlines. Default value is 4,
which means 5 gridlines: "0\%", "25\%", "50\%", "75\%", and "100\%".}

\item{cglwd}{Specifies the width of the gridlines. Default value is 1.}

\item{cglty}{Specifies the grid line style, which can be 1-6. Default value is 3.}

\item{vlcex}{Specifies the size of the group label font. Default value is 1.}

\item{axistype}{Specifies the style of the axis, which can be 0-5. Default value is 1.}

\item{t.size}{The size of picture title. Default value is 15.}

\item{t.vjust}{The vertical position of picture title, which can be negative or positivew values. Default value is 0.}

\item{t.color}{The color of picture title. Default value is "black".}

\item{l.postion}{The position of legend, which can be "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" or "center". Default value is "topright".}

\item{l.bty}{Whether the legend box is drawn, "o" means drawn, and the default value is "n" not drawn.}

\item{lt.col}{The color of legend text. Default value is "grey25".}

\item{lt.cex}{The fontsize of legend text. Default value is 2.}

\item{l.cex}{The size of legend. Default value is 1.}
}
\value{
No return value, called for side effects, which is a radar diagram based on lipid type, carbon number, or unsaturation among different groups.
}
\description{
A function to produce radar plot based on lipid types, carbon number, and number of double bonds.
}
\examples{
WT_1=rnorm(n=10,mean=0.4,sd=0.1)
WT_2=rnorm(n=10,mean=0.4,sd=0.1)
WT_3=rnorm(n=10,mean=0.4,sd=0.1)
WT_4=rnorm(n=10,mean=0.4,sd=0.1)
KO_1=rnorm(n=10,mean=0.8,sd=0.1)
KO_2=rnorm(n=10,mean=0.8,sd=0.1)
KO_3=rnorm(n=10,mean=0.8,sd=0.1)
KO_4=rnorm(n=10,mean=0.8,sd=0.1)
WT_treat_1=rnorm(n=10,mean=0.1,sd=0.1)
WT_treat_2=rnorm(n=10,mean=0.1,sd=0.1)
WT_treat_3=rnorm(n=10,mean=0.1,sd=0.1)
WT_treat_4=rnorm(n=10,mean=0.1,sd=0.1)
KO_treat_1=rnorm(n=10,mean=0.6,sd=0.1)
KO_treat_2=rnorm(n=10,mean=0.6,sd=0.1)
KO_treat_3=rnorm(n=10,mean=0.6,sd=0.1)
KO_treat_4=rnorm(n=10,mean=0.6,sd=0.1)
data=data.frame(WT_1,WT_2,WT_3,WT_4,KO_1,KO_2,KO_3,KO_4,
                WT_treat_1,WT_treat_2,WT_treat_3,WT_treat_4,
                KO_treat_1,KO_treat_2,KO_treat_3,KO_treat_4)
rownames(data)=c("LPC(16:0)","PC(14:0/16:1)","PC(18:1/18:1)","PE(18:0/20:1)",
                 "PS(20:1/20:1)","PI(16:0/16:1)","PC(18:0/18:1)","PA(16:0/16:1)",
                 "LPE(18:0)","PE(O-18:1/18:0)")
group=rep(c("WT","KO","WT_treat","KO_treat"),each=4)
plotRadar(data,"all",group) # This is the most simplified version
}
