% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearDetect-package.R
\name{BIC.threshold}
\alias{BIC.threshold}
\title{BIC threshold for final parameter estimation}
\usage{
BIC.threshold(
  method,
  beta.final,
  k,
  m.hat,
  brk,
  data_y,
  data_x = NULL,
  b_n = 2,
  nlam = 20
)
}
\arguments{
\item{method}{method name for the model: Constant: Mean-shift Model; MvLR: Multivariate Linear Regression; MLR: Multiple Linear Regression}

\item{beta.final}{a combined matrix of estimated parameter coefficient matrices for all stationary segementations}

\item{k}{dimensions of parameter coefficient matrices}

\item{m.hat}{number of estimated change points}

\item{brk}{vector of estimated change points}

\item{data_y}{input data matrix (response), with each column representing the time series component}

\item{data_x}{input data matrix (predictor), with each column representing the time series component}

\item{b_n}{the block size}

\item{nlam}{number of hyperparameters for grid search}
}
\value{
lambda.val.best, the tuning parameter lambda selected by BIC.
}
\description{
BIC threshold for final parameter estimation
}
