% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_pulses_above_threshold.R
\name{pulses_above_threshold}
\alias{pulses_above_threshold}
\title{Pulses above threshold}
\usage{
pulses_above_threshold(
  Light.vector,
  Time.vector,
  comparison = c("above", "below"),
  threshold,
  min.length = "8 mins",
  max.interrupt = "2 mins",
  prop.interrupt = 0.25,
  epoch = "dominant.epoch",
  return.indices = FALSE,
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data. Missing values will
be considered as \code{FALSE} when comparing light levels against the threshold.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct},
\link[hms]{hms}, \link[lubridate]{duration}, or \link[base]{difftime}.}

\item{comparison}{String specifying whether the time above or below threshold
should be calculated. Can be either \code{"above"} (the default) or \code{"below"}. If
two values are provided for \code{threshold}, this argument will be ignored.}

\item{threshold}{Single numeric value or two numeric values specifying the
threshold light level(s) to compare with. If a vector with two values is provided,
the timing corresponding to light levels between the two thresholds will be
calculated.}

\item{min.length}{The minimum length of a pulse. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}. Defaults to
\code{"8 mins"} as in Wilson et al. (2018).}

\item{max.interrupt}{Maximum length of each episode of interruptions. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}. Defaults to
\code{"2 mins"} as in Wilson et al. (2018).}

\item{prop.interrupt}{Numeric value between \code{0} and \code{1} specifying the
maximum proportion of the total number of interruptions. Defaults to \code{0.25}
as in Wilson et al. (2018).}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{return.indices}{Logical. Should the cluster indices be returned? Only works if
\code{as.df} is \code{FALSE}. Defaults to \code{FALSE}.}

\item{na.rm}{Logical. Should missing values be removed for the calculation of
pulse metrics? Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should a data frame be returned? If \code{TRUE}, a data
frame with seven columns ("n", "mean_level", "mean_duration", "total_duration",
"mean_onset", "mean_midpoint", "mean_offset") and the threshold (e.g., \verb{_\{threshold\}})
will be returned. Defaults to \code{FALSE}.}
}
\value{
List or data frame with calculated values.
}
\description{
This function clusters the light data into continuous clusters (pulses) of
light above/below a given threshold. Clustering may be fine-tuned by setting
the minimum length of the clusters and by allowing brief interruptions to be
included in a single cluster, with a specified maximum length of interruption
episodes and proportion of total amount of interruptions to light above
threshold.
}
\details{
The timeseries is assumed to be regular. Missing values in the
light data will be replaced by 0.
}
\examples{
# Sample data
data = sample.data.environment \%>\%
  dplyr::filter(Id == "Participant") \%>\%
  filter_Datetime(length = lubridate::days(1)) \%>\% 
  dplyr::mutate(
    Time = hms::as_hms(Datetime),
  )

# Time vector as datetime
data \%>\%
  dplyr::reframe(pulses_above_threshold(MEDI, Datetime, threshold = 250, as.df = TRUE))

# Time vector as hms time
data \%>\%
  dplyr::reframe(pulses_above_threshold(MEDI, Time, threshold = 250, as.df = TRUE))

# Pulses below threshold 
data \%>\%
  dplyr::reframe(pulses_above_threshold(MEDI, Datetime, "below", threshold = 250, as.df = TRUE))

# Pulses within threshold range
data \%>\%
  dplyr::reframe(pulses_above_threshold(MEDI, Datetime, threshold = c(250,1000), as.df = TRUE))

}
\references{
Wilson, J., Reid, K. J., Braun, R. I., Abbott, S. M., & Zee, P. C.
(2018). Habitual light exposure relative to circadian timing in delayed
sleep-wake phase disorder. \emph{Sleep}, 41(11).
\doi{10.1093/sleep/zsy166}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
