% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showVmGlgExamples.R
\name{testVmGlgExample}
\alias{testVmGlgExample}
\title{Perform unit tests of given standard values of the insurance contract example}
\usage{
testVmGlgExample(
  contract,
  prf = 10,
  t = 10,
  t_prf = 12,
  net,
  Zillmer,
  gross,
  written,
  savings,
  risk,
  ZillmerRes,
  ZillmerRes.prf,
  VwKostenRes,
  VwKostenRes.prf,
  Bilanzreserve,
  Praemienuebertrag,
  Rueckkaufsreserve,
  Rueckkaufswert,
  Abschlusskostenruecktrag,
  Rueckkaufswert.prf,
  VS.prf,
  absTolerance = 0.015,
  ...
)
}
\arguments{
\item{contract}{The insurance contract to calculate and check}

\item{prf}{Time of premium waiver (premium-free)}

\item{t}{Time for which to check all values (except premium-free values)}

\item{t_prf}{Time for which to check all values after the premium waiver}

\item{net, Zillmer, gross, written, savings, risk, ZillmerRes, ZillmerRes.prf, VwKostenRes, VwKostenRes.prf, Bilanzreserve, Praemienuebertrag, Rueckkaufsreserve, Rueckkaufswert, Abschlusskostenruecktrag, Rueckkaufswert.prf, VS.prf}{Values as printed out by showVmGlgExamples}

\item{absTolerance}{If non-NULL, will ignore small floating point differences. It uses same algorithm as all.equal()}

\item{...}{Further parameters for generating the contract for a tariff object}
}
\description{
Check the values of the example calculation of the given insurance contract
as required by the Austrian regulation (LV-VMGLV, "LV
Versicherungsmathematische Grundlagen Verordnung").
Missing params not passed to the function call will be silently ignored and
not cause unit test failures.
}
\details{
The easiest way to write unit-tests is using the function \code{vmGlgExample.generateTest}
}
\examples{
library(MortalityTables)
mortalityTables.load("Austria_Annuities_AVOe2005R")

\dontrun{
test_that("Testtarif", {
    # A trivial deferred annuity tariff with no costs:
    tariff = InsuranceTarif$new(name="Test Annuity", type="annuity",
        mortalityTable = AVOe2005R.unisex, i=0.01)
    contract = InsuranceContract$new(
        tariff,
        age = 35, YOB = 1981,
        policyPeriod = 30, premiumPeriod = 15, deferralPeriod = 15,
        sumInsured = 1000,
        contractClosing = as.Date("2016-10-01")
    );

    testVmGlgExample(
        contract, t = 10,
        net = 850.09, # NOT_CHECKED: Zillmer = 950.09,
        gross = 850.09,
        written = 884.09,
        savings = 857.09, risk = -7.00,
        ZillmerRes = 9011.40,
        ZillmerRes.prf = 9205.96,
        VwKostenRes = 0.00,
        VwKostenRes.prf = 0.00,
        Bilanzreserve = 9250.35,
        Praemienuebertrag = 212.52,
        Rueckkaufsreserve = 9011.40,
        Rueckkaufswert = 9011.40,
        Abschlusskostenruecktrag = 0.00,
        Rueckkaufswert.prf = 9205.96,
        VS.prf = 685.12
    )
})
}

}
