% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexisNexisTools.R
\name{lnt_lookup}
\alias{lnt_lookup}
\title{Lookup keywords in articles}
\usage{
lnt_lookup(
  x,
  pattern,
  case_insensitive = FALSE,
  unique_pattern = FALSE,
  word_boundaries = c("both", "before", "after"),
  cores = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{An LNToutput object or a string or vector of strings.}

\item{pattern}{A character vector of keywords. Word boundaries before and
after the keywords are honoured (see \code{word_boundaries}). Regular
expression can be used.}

\item{case_insensitive}{If FALSE, the pattern matching is case sensitive and
if TRUE, case is ignored during matching.}

\item{unique_pattern}{If TRUE, duplicated mentions of the same pattern are
removed.}

\item{word_boundaries}{If TRUE or "both", lookup is performed with word
boundaries at beginning and end of the pattern (i.e., pattern "protest"
will not identify "protesters" etc.). Additionally word boundaries can be
either just in front of the pattern ("before") or after the pattern
("after"). FALSE searches without word boundaries.}

\item{cores}{The number of CPU cores to use. Use \code{NULL} or \code{1} to
turn off.}

\item{verbose}{A logical flag indicating whether a status bar is printed to
the screen.}
}
\value{
A list of keyword hits.
}
\description{
This function looks for the provided pattern in the string or
  LNToutput object. This can be useful, for example, to see which of the
  keywords you used when retrieving the data was used in each article.
}
\details{
If an LNToutput object is provided, the function will look for the
  pattern in the headlines and articles. The returned object is a list of
  hits. If a regular expression is provided, the returned word will be the
  actual value from the text.
}
\examples{
# Make LNToutput object from sample
LNToutput <- lnt_read(lnt_sample(copy = FALSE))

# Lookup keywords
LNToutput@meta$Keyword <- lnt_lookup(
  LNToutput,
  "statistical computing"
)

# Keep only articles which mention the keyword
LNToutput_stat <- LNToutput[!sapply(LNToutput@meta$Keyword, is.null)]

# Convert list of keywords to string
LNToutput@meta$Keyword <- sapply(LNToutput@meta$Keyword, toString)
}
\author{
Johannes Gruber
}
