% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnt_checkFiles.R
\name{lnt_checkFiles}
\alias{lnt_checkFiles}
\title{Check LexisNexis TXT files}
\usage{
lnt_checkFiles(x, encoding = "UTF-8",
  start_keyword = "\\\\d+ of \\\\d+ DOCUMENTS$| Dokument \\\\d+ von \\\\d+$",
  end_keyword = "^LANGUAGE: |^SPRACHE: ",
  length_keyword = "^LENGTH: |^LÄNGE: ", verbose = TRUE)
}
\arguments{
\item{x}{Name or names of LexisNexis TXT file to be converted.}

\item{encoding}{Encoding to be assumed for input files. Defaults to UTF-8
(the LexisNexis standard value).}

\item{start_keyword, end_keyword, length_keyword}{see \link{lnt_read}.}

\item{verbose}{A logical flag indicating whether information should be
printed to the screen.}
}
\description{
Read a LexisNexis TXT file and check consistency.
}
\details{
The output will contain three tests:
- test1: 
Indicates whether the number of beginnings and the number of ends
match in a file. It is critical, that this is TRUE. Otherwise \link{lnt_read}
will not be able to separate individual articles from each other. 
- test2:
Indicates whether the number of beginnings and the number of lengths match.
As 'LENGTH' is used to separate metadata from actual articles, it is
critical, that this is TRUE. Otherwise \link{lnt_read} will fail with an error
when trying to read this file.
- test3:
Indicates whether the number of beginnings equals the number of articles
LexisNexis delivered. It is most likely not a problem if this is FALSE, as
some articles from nexis are empty and therefore get deleted. So far, this
has only been the case when an article contained a photo and nothing else.

Can check consistency of LexisNexis txt files. lnt_read needs at
  least Beginning, End and length in each article to work.
}
\examples{
# Copy sample file to current wd
lnt_sample()

# Search for txt files in working directory
my_files<-list.files(pattern = ".TXT",
                     full.names = TRUE,
                     recursive = TRUE,
                     ignore.case = TRUE)
# Test consistency of files
checks.df <- lnt_checkFiles(my_files)
checks.df
}
\author{
Johannes B. Gruber
}
\keyword{LexisNexis}
