% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReflectedPoint.R
\name{ReflectedPoint}
\alias{ReflectedPoint}
\title{Computes the reflected point about a line of a given point}
\usage{
ReflectedPoint(P, Line)
}
\arguments{
\item{P}{Vector containing the xy-coordinates of a point}

\item{Line}{Line object previously created with \code{CreateLinePoints} or \code{CreateLineAngle}, to be used as the axis of symmetry}
}
\value{
Returns a vector which contains the xy-coordinates of the reflected point
}
\description{
\code{ReflectedPoint} computes the reflected point about a line of a given point
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
xx <- c(0,1,2)
yy <- c(0,1,0)
P1 <- c(0,0)
P2 <- c(1,1)
Line <- CreateLinePoints(P1, P2)
Draw(Line, "black")
P <- c(-2,2)
Draw(P, "black")
reflected <- ReflectedPoint(P, Line)
Draw(reflected, "red")
}
