% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/H.R
\name{H}
\alias{H}
\title{Transformation that defines the Lambert W function}
\usage{
H(u)
}
\arguments{
\item{u}{a numeric vector of real/complex values.}
}
\value{
Returns \eqn{z = u \exp(u)} for \eqn{u \in C}. If \eqn{u} is a
vector/matrix, so is \eqn{z}.
}
\description{
The Lambert W function \eqn{W(z)} is the inverse of \eqn{H(u) = u \exp(u) = z}.
}
\examples{
H(0)
H(10)

plot(H, -5, 0.5, type="l", xlab="u", ylab="z")
grid()
abline(h=0, lty = 2)
abline(v=0, lty = 2)
}
\seealso{
\code{\link{W}}
}
\keyword{math}

