% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DD.R
\name{DD}
\alias{DD}
\title{Design diagram for a linear model}
\usage{
DD(fixed, random = NULL, data, keep = ~1, center = FALSE, eps = 1e-12)
}
\arguments{
\item{fixed}{formula with fixed effects. A response may the specified, but this optional.}

\item{random}{formula with random effects. Defaults to \code{NULL} meaning that there are no other random effects than the residual, which is added to all designs.}

\item{data}{data frame with the explanatory variables and the response (if specified).}

\item{keep}{formula which effects that will not be removed in the collinarity analysis. Defaults to \code{~1} meaning that the intercept will be kept if it is present.}

\item{center}{boolean deciding whether to centralize numerical predictors when an intercept is present. Defaults to \code{FALSE}.}

\item{eps}{threshold for deeming singular values to be "zero". Defaults to 1e-12.}
}
\value{
An object of class \code{\link{designDiagram-class}}
}
\description{
\code{DD} computes the Design Diagram for a linear model.
}
\examples{
# 3-way ANOVA
x <- factor(rep(rep(1:4,times=4),times=4))
y <- factor(rep(rep(1:4,times=4),each=4))
z <- factor(rep(rep(1:4,each=4),each=4))
myDD <- DD(~x*y*z,data=data.frame(x=x,y=y,z=z))
summary(myDD)

#Making the factor diagram closed under minima
mydata <- data.frame(age=rep(c("boy","girl","adult","adult"),4),
                     gender=rep(c("child","child","man","woman"),4))
myDD <- DD(~0+age+gender,data=mydata)
plot(myDD)

# Example of collinearity
mydata <- data.frame(age=rnorm(102),edu=rnorm(102),sex=factor(rep(c(1,2),51)))
mydata <- transform(mydata,exper=age-edu+0.1*rnorm(102))
mydata <- transform(mydata,wage=2*edu+2*exper+rnorm(102))
summary(myDD <- DD(wage~sex*(age+exper+edu),data=mydata))

# growth of rats
antibiotica <- factor(rep(c(0,40),each=6))
vitamin <- factor(rep(rep(c(0,5),each=3),2))
growth <- c(1.30,1.19,1.08,1.26,1.21,1.19,1.05,1.00,1.05,1.52,1.56,1.55)
mydata <- data.frame(antibiotica=antibiotica,vitamin=vitamin,growth=growth)
myDD <- DD(growth~antibiotica*vitamin,data=mydata)
plot(myDD,"MSS")
plot(myDD,"I2")

\donttest{
  # ANCOVA: Non-orthogonal design
  library(isdals)
  data(birthweight)
  plot(DD(weight~sex*I(age-42),data=birthweight),"MSS")
  plot(DD(weight~I(age-42)+sex:I(age-42)+sex,data=birthweight),"MSS")
}

}
\seealso{
\code{\link{minimum}}, \code{\link{plot.designDiagram}}
}
\author{
Bo Markussen
}
\keyword{design}
\keyword{manip}
