% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoding_functions.R
\name{viterbi_g}
\alias{viterbi_g}
\title{Viterbi algorithm for state decoding in inhomogeneous HMMs}
\usage{
viterbi_g(delta, Gamma, allprobs, trackID = NULL, mod = NULL)
}
\arguments{
\item{delta}{initial distribution of length N, or matrix of dimension c(k,N) for k independent tracks, if \code{trackID} is provided}

\item{Gamma}{array of transition probability matrices of dimension c(N,N,n-1), as in a time series of length n, there are only n-1 transitions

If an array of dimension c(N,N,n) is provided for a single track, the first slice will be ignored.

If \code{trackID} is provided, \code{Gamma} needs to be an array of dimension c(N,N,n), where n is the number of rows in \code{allprobs}. Then for each track the first transition matrix will be ignored.}

\item{allprobs}{matrix of state-dependent probabilities/ density values of dimension c(n, N)}

\item{trackID}{optional vector of k track IDs, if multiple tracks need to be decoded separately}

\item{mod}{optional model object containing initial distribution \code{delta}, transition probability matrix \code{Gamma}, matrix of state-dependent probabilities \code{allprobs}, and potentially a \code{trackID} variable

If you are using automatic differentiation either with \code{RTMB::MakeADFun} or \code{\link{qreml}} and include \code{\link{forward_g}} in your likelihood function, the objects needed for state decoding are automatically reported after model fitting.
Hence, you can pass the model object obtained from running \code{RTMB::report()} or from \code{\link{qreml}} directly to this function.}
}
\value{
vector of decoded states of length n
}
\description{
The Viterbi algorithm allows one to decode the most probable state sequence of an HMM.
}
\examples{
delta = c(0.5, 0.5)
Gamma = array(dim = c(2,2,99))
for(t in 1:99){
  gammas = rbeta(2, shape1 = 0.4, shape2 = 1)
  Gamma[,,t] = matrix(c(1-gammas[1], gammas[1], 
                      gammas[2], 1-gammas[2]), nrow = 2, byrow = TRUE)
}
allprobs = matrix(runif(200), nrow = 100, ncol = 2)
states = viterbi_g(delta, Gamma, allprobs)
}
\seealso{
Other decoding functions: 
\code{\link{stateprobs}()},
\code{\link{stateprobs_g}()},
\code{\link{stateprobs_p}()},
\code{\link{viterbi}()},
\code{\link{viterbi_p}()}
}
\concept{decoding functions}
