% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDE_simulate.R
\name{GOU_simulate}
\alias{GOU_simulate}
\title{Simulate the geometric Ornstein-Uhlenbeck (GOU) stochastic process through Monte Carlo simulation}
\usage{
GOU_simulate(n, t, reversion_rate, sigma, equilibrium, risk_premium, S0, dt)
}
\arguments{
\item{n}{The total number of price paths to simulate}

\item{t}{The forecasting period, in years}

\item{reversion_rate}{The reversion rate term of the GOU process}

\item{sigma}{The volatility term of the GOU process}

\item{equilibrium}{The equilibrium term of the GOU process}

\item{risk_premium}{The risk premium of the GOU process}

\item{S0}{The initial value of the underlying asset}

\item{dt}{The discrete time step of observations, in years

A stochastic process S(t) is an IGBM that follows the following continuous-time stochastic differential equation:
\deqn{ dS(t)/ = reversion_rate(equilibrium - S(t)) dt + \sigma dW(t)}{dS(t) = reversion_rate(equilibrium - S(t)) dt + sigma dW(t)}

\deqn{\frac{dS(t)}{S(t)} = equilibrium - (reversion_rate * S(t) + risk_premium) dt + \sigma dW(t)}{dS(t)/S(t) = dS(t)/S(t) = equilibrium + (- reversion_rate * S(t) - risk_premium) dt + sigma dW(t)}

Where 'reversion_rate' is the rate of reversion term, 'equilibrium' is the equilibrium value the process reverts towards, 'risk_premium' is the risk premium of the process, \eqn{\sigma}{'sigma'} the volatility term and \eqn{W_{t}}{W(t)} is defined as a Weiner process.}
}
\value{
A matrix of simulated price paths of the GOU process. Each column corresponds to a simulated price path, and each
row corresponds to a simulated observed price of the simulated price paths at each discrete time period.
}
\description{
The geometric Ornstein-Uhlenbeck process is a member of the general affine class of stochastic process. The Ornstein-Uhlenbeck process is a Gaussian process, a Markov process, is temporally homogeneous and exhibits mean-reverting behaviour.
The \code{IGBM_simulate} function utilizes antithetic variates as a simple variance reduction technique.
}
\examples{
## 100 simulations of 1 year of monthly price paths:
Simulated <- GOU_simulate(n = 100,
                         t = 1,
                         reversion_rate = 1,
                         sigma = 0.2,
                         equilibrium = 100,
                         risk_premium = 0.05,
                         S0 = 100,
                         dt = 1/12)
}
