% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.heatboxplot.R
\name{heatboxplot}
\alias{LSD.heatboxplot}
\alias{heatboxplot}
\title{Heatboxplot: a colored boxplot}
\usage{
heatboxplot(x, horizontal = FALSE, add = FALSE, colpal = "standard",
  rev = FALSE, simulate = FALSE, daltonize = FALSE, cvd = "p",
  alpha = NULL, colpals = NULL, nrcol = 75, lwd = 1.75, axes = TRUE,
  labels = NULL, xlim = NULL, ylim = NULL, xlab = NULL, ylab = "",
  main = "heatboxplot", nolab = FALSE, outline = TRUE, boxonly = FALSE,
  adjust = 1, quant.from = 0.25, quant.to = 0.75, range = 1.5,
  border = "black", plot.boxplot = TRUE, add.quartiles = TRUE,
  add.box = FALSE, n.density = 1024, cexbox = 0.6, ...)
}
\arguments{
\item{x}{data as vector, matrix, list or data.frame.}

\item{horizontal}{logical: if \code{TRUE} (\code{FALSE} by default), rotation of 90 degrees is applied.}

\item{add}{logical: if \code{TRUE} (\code{FALSE} by default), the boxplot is added to an existing plot.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}) (defaults to "heat", if not specified).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{colpals}{a character vector containing names of \code{LSD} colorpalettes (see disco() or \code{\link{disco}}).}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to 100, if not specified).}

\item{lwd}{linewidth of the box and whiskers.}

\item{axes}{logical: if \code{TRUE} (by default), the axes are plotted.}

\item{labels}{a character vector of labels.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{xlab}{x label, standard graphics parameter.}

\item{ylab}{y label, standard graphics parameter.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{nolab}{logical: if \code{TRUE} (\code{FALSE} by default), the title and ylab are suppressed.}

\item{outline}{logical: if \code{TRUE} (by default), outliers are plotted.}

\item{boxonly}{logical: if \code{TRUE} (\code{FALSE} by default), the density is only be plotted in the box.}

\item{adjust}{a numeric value giving the scaling factor for the used bandwidth (defaults to 1).}

\item{quant.from}{a numeric value (between 0 and 1) giving the quantile from which the density lane should be plotted.}

\item{quant.to}{a numeric value (between 0 and 1) giving the quantile to which the density lane should be plotted.}

\item{range}{a numeric value to determine how far the plot whiskers extend out from the box.}

\item{border}{an R build-in color for the box and whiskers.}

\item{plot.boxplot}{logical: if \code{TRUE} (by default), the boxplot is added to the density.}

\item{add.quartiles}{if \code{TRUE} (\code{FALSE} by default), only the box of the boxplot is added (if \code{plot.boxplot = FALSE}).}

\item{add.box}{logical: if \code{TRUE} (by default), the box is added to the plot.}

\item{n.density}{an integer specifying the number of equally spaced points at which the density is to be estimated.}

\item{cexbox}{a numerical value giving the amount by which the boxes should be magnified relative to the default.}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
A boxplot with an additional color stripe based on a kernel density estimate.
}
\examples{
f = c(rnorm(200),rnorm(200)+4)
h = rf(500,15,15)*10
g = rnorm(300)+1

heatboxplot(h)

heatboxplot(list(f=f,g=g),colpals=c("rdpu","greens"),labels=c("bimodal","unimodal"))
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{boxplot}

