% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.lrtest}
\alias{print.lrtest}
\title{Print results of tests.}
\usage{
\method{print}{lrtest}(x, ...)
}
\arguments{
\item{x}{a test from LRTesteR.}

\item{...}{arguments passed to other methods.}
}
\description{
Print results of tests.
}
\examples{
library(LRTesteR)

set.seed(1)
x <- rnorm(100, 0, 1)
test <- gaussian_mu_one_sample(x, 0, "two.sided")
print(test)

set.seed(1)
x <- rnorm(150, 1, 1)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
test <- gaussian_mu_one_way(x, fctr, .95)
print(test)
}
