% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential_tests.R
\name{exponentail_rate_lr_test}
\alias{exponentail_rate_lr_test}
\title{Test the rate of a exponential distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
exponentail_rate_lr_test(x, rate, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values.}

\item{rate}{a number indicating the tested value of rate.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the rate of a exponential distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rexp(100, 1)
exponentail_rate_lr_test(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rexp(100, 3)
exponentail_rate_lr_test(x, 1, "greater")
}
