\name{lpc.spline.auxiliary.functions}
\Rdversion{1.1}
\alias{lpc.splinefun}
\alias{lpc.fit.spline}
\alias{lpc.spline.eval}
\alias{lpc.project.spline}
\alias{lpc.curve.length}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Auxiliary functions for spline fitting and projection.
}
\description{
Internal functions of package \pkg{LPCM} called by \code{lpc.spline} and others. These will rarely be called directly by the user.
}
\usage{
lpc.splinefun(lpcobject)

lpc.fit.spline(lpcsl, num.knots = 100)

lpc.spline.eval(lpcsl, or.pi, branch = 0)

lpc.project.spline(lpcsl, newdata, num.knots = 100, optimize = TRUE)

lpc.curve.length(lpcsl, or.pi, branch = 0, total.subdivisions = 10000,
      min.subdivisions = 100)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{lpcobject}{Object of type \code{lpc}.}
  \item{lpcsl}{ Object generated by \code{lpc.splinefun}.}
  \item{num.knots}{number of spline knots }
  \item{or.pi}{original projection index}
  \item{branch}{branch ID}
\item{newdata}{new data frame}
\item{optimize}{Boolean.}
 \item{total.subdivisions}{total number of subdivisions for arc length computation.}
 \item{min.subdivisions}{minimum number of subdivisions for arc length computation.}
}

%\details{
%}

\author{
L. Evers and J. Einbeck
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{lpc.spline}}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{smooth}
%\keyword{multivariate}% __ONLY ONE__ keyword per line
