% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDA.R
\name{sliced_Wd}
\alias{sliced_Wd}
\title{sliced_Wd}
\usage{
sliced_Wd(Dg1, Dg2, M = 10, sigma = 1, dimensions = NULL, return.dist = FALSE)
}
\arguments{
\item{Dg1}{a persistence diagram as a n1 x 3 matrix where each row is a topological feature
and the columns are dimension, birth and death of the feature.}

\item{Dg2}{another persistence diagram as a n2 x 3 matrix}

\item{M}{number of slices (default: 10)}

\item{sigma}{kernel bandwidth (default: 1)}

\item{dimensions}{vector of the dimensions of the topological features to consider, if NULL (default) use all available dimensions}

\item{return.dist}{logical (default: FALSE). Whether to return the kernel or distance value.}
}
\value{
kernel or distance value
}
\description{
Compute sliced Wasserstein distance or kernel. 
Reference: Mathieu Carriere, Marco Cuturi, and Steve Oudot. Sliced Wasserstein kernel for persistence diagrams. In Proceedings of the 34th International Conference on Machine Learning, volume 70 of Proceedings of Machine Learning Research, pages 664–673, 2017.
}
\examples{
D1 <- matrix(c(0,0,0,1,1,0,0,0,1.5, 3.5,2,2.5,3, 4, 6), ncol = 3, byrow = FALSE)
D2 <- matrix(c(0,0,1,1,0, 0, 1.2, 2, 1.4, 3.2,4.6,6.5), ncol = 3, byrow = FALSE)
K <- sliced_Wd(Dg1 = D1, Dg2 = D2, M = 10, sigma = 1, return.dist = TRUE)
}
