% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.lmm}
\alias{fitted.lmm}
\title{Predicted Mean Value For Linear Mixed Model}
\usage{
\method{fitted}{lmm}(
  object,
  newdata = NULL,
  impute = FALSE,
  se.impute = FALSE,
  keep.newdata = FALSE,
  format = "long",
  simplify = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{newdata}{[data.frame] the covariate values for each cluster.}

\item{impute}{[logical] Should the missing data in the outcome be imputed based on covariates and other outcome values from the same cluster.}

\item{se.impute}{[character] If \code{FALSE} the most likely value is imputed. Otherwise the imputed value is sampled from a normal distribution.
The value of the argument determine which standard deviation is used: all uncertainty about the predicted value (\code{"total"}),
only uncertainty related to the estimation of the model parameters (\code{"estimate"}), or only uncertainty related to the residual variance of the outcome (\code{"residual"}).
Passed to \code{predict.lmm}.}

\item{keep.newdata}{[logical] Should the dataset relative to which the predictions are evaluated be output along side the predicted values?
Only possible in the long format.}

\item{format}{[character] Should the prediction be output
in a matrix format with clusters in row and timepoints in columns (\code{"wide"}),
or in a data.frame/vector with as many rows as observations (\code{"long"})}

\item{simplify}{[logical] Simplify the data format (vector instead of data.frame) and column names (no mention of the time variable) when possible.}

\item{seed}{[integer, >0] Random number generator (RNG) state used when starting imputation.
If \code{NULL} no state is set.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
When \code{format="wide"}, a data.frame with as many rows as clusters.
When \code{format="long"} or \code{keep.newdata==TRUE}, a data.frame with as many rows as observations.
Otherwise: \itemize{
\item if \code{impute=FALSE} a vector of length the number of row of newdata containing the fitted values (i.e. based on the covariates only).
\item if \code{impute=TRUE} a vector of length the number of missing values in the outcome of newdata containing the cluster-specific conditional means
(i.e. based on the covariates and outcome measurements from the same cluster).
}

When \code{keep.newdata==TRUE}, a dataframe with an additional column containing the fitted values (i.e. based on the covariates only).
If \code{impute=TRUE}, the missing value in the outcome column are replaced by the cluster-specific conditional means
(i.e. based on the covariates and outcome measurements from the same cluster).
}
\description{
Predicted Mean Value For Linear Mixed Model
}
\examples{
#### simulate data in the long format ####
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

#### fit Linear Mixed Model ####
eCS.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id,
               structure = "CS", data = dL, df = FALSE)

## prediction
fitted(eCS.lmm)
fitted(eCS.lmm, newdata = data.frame(X1 = 1, X2 = 2, X5 = 3))
fitted(eCS.lmm, newdata = data.frame(X1 = 1, X2 = 2, X5 = 3), keep.newdata = TRUE)

#### fit Linear Mixed Model with missing data ####
dL2 <- dL
dL2[3,"Y"] <- NA
eCS2.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id,
                structure = "CS", data = dL2, df = FALSE)

## most likely value to impute
fitted(eCS2.lmm, impute = TRUE)
head(fitted(eCS2.lmm, impute = TRUE, keep.newdata = TRUE))

## multiple imputation
dL2.imp1 <- data.frame(imp = "1",
    fitted(eCS2.lmm, impute = TRUE, se.impute = "total", keep.newdata = TRUE))
dL2.imp2 <- data.frame(imp = "2",
    fitted(eCS2.lmm, impute = TRUE, se.impute = "total", keep.newdata = TRUE))
head(dL2.imp1)
head(dL2.imp2)
}
\keyword{methods}
