% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{coef.LMMsolve}
\alias{coef.LMMsolve}
\title{Coefficients from the mixed model equations of an LMMsolve object.}
\usage{
\method{coef}{LMMsolve}(object, ...)
}
\arguments{
\item{object}{an object of class LMMsolve}

\item{\dots}{some methods for this generic require additional arguments.
None are used in this method.}
}
\value{
A list of vectors, containing the estimated effects for each fixed
effect and the predictions for each random effect in the defined linear
mixed model.
}
\description{
Obtain the coefficients from the mixed model equations of an LMMsolve object.
}
\examples{
## Fit model on john.alpha data from agridat package.
data(john.alpha, package = "agridat")

## Fit simple model with only fixed effects.
LMM1 <- LMMsolve(fixed = yield ~ rep + gen,
                data = john.alpha)

## Obtain coefficients.
coefs1 <- coef(LMM1)

}
