% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latentMelsm.R
\name{.detect_L2_only}
\alias{.detect_L2_only}
\title{Detect whether the predictors are L2-only}
\usage{
.detect_L2_only(mf, group)
}
\arguments{
\item{mf}{Data frame for predictors. Should contain no missings.}

\item{group}{Grouping variable for the model frame.}
}
\value{
Logical. TRUE if the covariates appear to be level-2 only.
}
\description{
Detects whether the predictors are level-2 only.
E.g., whether location and scale are covariates are the same across all n_k observations of each K.
This is important for efficiency reasons.
If the covariates are invariant across repeated observations of the given group k, for all K, then we can compute predicted values once, and broadcast the prediction, rather than compute the prediction for every single row.
Specifically, it detects if all \code{x == x[1]}, where x is a group's data, for each column in mf.
}
\author{
Stephen R. Martin
}
\keyword{internal}
