% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmd.R
\name{lmd}
\alias{lmd}
\title{Local Mean Decomposition}
\usage{
lmd(
  signal,
  include_endpoints = TRUE,
  max_smooth_iteration = 12,
  max_envelope_iteration = 200,
  envelope_epsilon = 0.01,
  convergence_epsilon = 0.01,
  max_num_pf = 8
)
}
\arguments{
\item{signal}{Signal values (Numeric | vector)}

\item{include_endpoints}{Whether to treat the endpoint of the signal as a pseudo-extreme point (Boolean)}

\item{max_smooth_iteration}{Maximum number of iterations of moving average algorithm (Integer)}

\item{max_envelope_iteration}{Maximum number of iterations when separating local envelope signals (Integer)}

\item{envelope_epsilon}{Terminate processing when obtaining pure FM signal (Double)}

\item{convergence_epsilon}{Terminate processing when modulation signal converges (Double)}

\item{max_num_pf}{The maximum number of PFs generated(Integer)}
}
\value{
list(pf,residue) | PFs:The decompose functions arranged from high frequency to low frequency | residue:residual component
}
\description{
Method for finding Product Functions (PFs)
}
\details{
LMD is a method of decomposing signal into Product Functions (PFs) based on algorithm presented in Jonathan S. Smith. The local mean decomposition and its application to EEG perception data. Journal of the Royal Society Interface, 2005, 2(5):443-454
}
\examples{
x=1:100
y = (2 / 3 )* sin(x * 30) + (2 / 3) * sin(x * 17.5) + (4 / 5) *cos(x * 2)
plot(y,type="l")
lmd(y)
}
\references{
\url{https://pypi.org/project/PyLMD/}
}
\author{
Shubhra Prakash, \email{shubhraprakash279@gmail.com}
}
\keyword{Demodulation}
\keyword{Fault}
\keyword{Local}
\keyword{Product}
\keyword{decomposition}
\keyword{diagnosis}
\keyword{functions}
\keyword{lmd}
\keyword{mean}
\keyword{mechanism}
\keyword{self-adaptive}
