% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR_tidy.R
\name{llm_mutate}
\alias{llm_mutate}
\title{Mutate a data frame with LLM output}
\usage{
llm_mutate(
  .data,
  output,
  prompt,
  .config,
  .system_prompt = NULL,
  .before = NULL,
  .after = NULL,
  ...
)
}
\arguments{
\item{.data}{A data frame / tibble.}

\item{output}{Unquoted name of the new column you want to add.}

\item{prompt}{A glue template string.
*If* \code{x} is a data frame, use \code{{col}} placeholders;
*if* \code{x} is a vector, refer to the element as \code{{x}}.}

\item{.config}{An \link{llm_config} object.}

\item{.system_prompt}{Optional system message (character scalar).}

\item{.before, .after}{Standard \link[dplyr]{mutate} column-placement helpers.}

\item{...}{Passed unchanged to \link{call_llm_broadcast} (e.g.\ \code{tries},
\code{progress}, \code{verbose}).}
}
\description{
A convenience wrapper around \link{llm_fn} that inserts the result as a new
column via \link[dplyr]{mutate}.
}
\details{
Internally calls `llm_fn()`, so the API requests inherit the same
parallel behaviour.  Activate parallelism with
`setup_llm_parallel()` and shut it off with `reset_llm_parallel()`.
}
\examples{
## See examples under \link{llm_fn}.
}
\seealso{
llm_fn, setup_llm_parallel, reset_llm_parallel
}
