% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SA2008.R
\name{SA2008}
\alias{SA2008}
\title{Simulated Annealing for LHD with Multi-objective Optimization Approach}
\usage{
SA2008(n, k, N, T0, rate, Tmin, Imax, p = 15, q = 1)
}
\arguments{
\item{n}{A positive integer.}

\item{k}{A positive integer.}

\item{N}{A positive integer.}

\item{T0}{A positive number.}

\item{rate}{A positive percentage.}

\item{Tmin}{A positive number.}

\item{Imax}{A positive integer.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{SA2008} returns a maximin distance LHD constructed by simulated annealing algorithm with multi-objective optimization approach.
}
\details{
\itemize{
\item \code{n} stands for the number of rows (or run size).
\item \code{k} stands for the number of columns (or the number of factors).
\item \code{N} stands for the number of iterations.
\item \code{T0} stands for the user-defined initial temperature.
\item \code{rate} stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time.
\item \code{Tmin} stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met.
\item \code{Imax} stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 5.
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
}
}
\note{
This modified simulated annealing algorithm reduces columnwise correlations, but with a cost of more computational time.
}
\examples{
#create a 5 by 3 maximin distance LHD, with # of iterations =10, initial
#temperature is set to be 10, decrease rate is 10\%, minimium temperature is 1,
#maximum perturbations the algorithm will try without improvements is 5, and p=50
try=SA2008(n=5,k=3,N=10,T0=10,rate=0.1,Tmin=1,Imax=5,p=50,q=1)
try
phi_p(try,p=50)   #calculate the phi_p of "try".

#Another example with different input
try2=SA2008(n=9,k=2,N=5,T0=8,rate=0.1,Tmin=1,Imax=3,p=50,q=1)
try2
}
\references{
Joseph, V.R., and Hung, Y. (2008) Orthogonal-maximin Latin hypercube designs. \emph{Statistica Sinica}, \strong{18}, 171-186.
}
