% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICARL_CUSUM_down.R
\name{GICARL_CUSUM_down}
\alias{GICARL_CUSUM_down}
\title{ARL Calculation for a Downward CUSUM Control Chart with a Gamma Distribution}
\usage{
GICARL_CUSUM_down(
  alpha,
  beta,
  alpha_est,
  beta_est,
  beta_ratio,
  H_minus,
  H_delta,
  m
)
}
\arguments{
\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{alpha_est}{Estimated shape parameter.}

\item{beta_est}{Estimated scale parameter.}

\item{beta_ratio}{Ratio between \code{beta} and its estimation.}

\item{H_minus}{Lower control limit of the downward CUSUM chart.}

\item{H_delta}{Increment of the GIC threshold.}

\item{m}{Number of divisions for the probability matrix.}
}
\value{
A numeric value representing the average run length (\strong{ARL}) of the downward CUSUM control chart.
}
\description{
This function estimates the average run length (\strong{ARL}) of a downward CUSUM control chart applied to a Gamma distribution with guaranteed performance (GIC), considering both known and estimated parameters.

This approach follows the methodology described in the work of Madrid‐Alvarez, García-díaz, and Tercero‐Gómez(2024),
which provides a detailed analysis of the performance of CUSUM control charts for Gamma distributions with guaranteed efficiency.
Specifically, the method implemented in this function enables the precise evaluation of ARL under different parameter settings,
ensuring appropriate calibration and monitoring of controlled processes.
\subsection{\strong{Recommendations}}{

For further consultation and to review values of \code{H_delta} and \code{H_minus}, it is recommended to refer to the following article:
Madrid‐Alvarez, H. M., García‐Díaz, J. C., & Tercero‐Gómez, V. G. (2024).
\strong{A CUSUM control chart for gamma distribution with guaranteed performance}. Quality and Reliability Engineering.
}

\subsection{Considerations:}{
\itemize{
\item The control chart is calibrated with \code{beta = 1}.
\item When \code{alpha} and \code{beta} are known, it is recommended to use the same values for \code{alpha_est = alpha} and \code{beta_est = 1}.
\item Higher values of \code{m} increase the accuracy of the results (\verb{m = \{10, 100\}}).
}
}
}
\examples{
# Example with known parameters
GICARL_CUSUM_down(alpha = 1, beta = 1, alpha_est = 1, beta_est = 1,
                  beta_ratio = 1/2.5, H_minus = -2.792, H_delta = 0, m = 100)

# Example with estimated parameters
GICARL_CUSUM_down(alpha = 1, beta = 1, alpha_est = 1, beta_est = 1.1,
                  beta_ratio = 1/2, H_minus = -4.1497, H_delta = 1.5167,
                  m = 100)

}
