% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsK.R
\name{plotHDLVrncToLDL}
\alias{plotHDLVrncToLDL}
\title{Plots LDL variance versus increasing HDL variance}
\usage{
plotHDLVrncToLDL(dfHDLVars, LDLHDLVrncErrProp, LDLHDLVrncBoot)
}
\arguments{
\item{dfHDLVars}{A data frame with increasing variances of HDL.}

\item{LDLHDLVrncErrProp}{A vector with the error propagation variances of LDL when the
HDL variance increases.}

\item{LDLHDLVrncBoot}{A vector with the bootstrap variances of LDL when the
HDL variance increases.}
}
\value{
The function creates a plot with the LDL error propagation and
bootstrap variances versus increasing HDL variances.
}
\description{
Plots the variance of LDL (both Error Propagation and Bootstrap variance)
versus increasing HDL variance.
}
\examples{
\donttest{
## For LDL - HDL:
# Make the DF of ascending variances for HDL of sample
HDLVariances = CV_Range(sampleA$HDL,15,25,plot=FALSE)
# Get the Error Propagation and the Bootstrap variance of LDL relative to HDL
LDLHDLSampleDependance = LDL_HDLVrnc(HDLVariances,sampleA$CHOL, sampleA$TG, bootStrpReps=2000)
plotHDLVrncToLDL(HDLVariances,LDLHDLSampleDependance$ErrPropVrnc,LDLHDLSampleDependance$BootVrnc)
}
}
