#' @title Linkage Disequilibrium of Ancestry (LDA) and LDA Score (LDAS)
#'
#' @description
#' This is the software for Linkage disequilibrium of ancestry (LDA) and LDA score (LDAS) which is proposed by
#' the papar Genetic risk for Multiple Sclerosis originated in Pastoralist Steppe populations,
#' Barrie W, Yang Y, Attfield K E, et al (2022).
#'
#' LDA quantifies the correlations between the ancestry of two SNPs,
#' measuring the proportion of individuals who have experienced a recombination
#' leading to a change in ancestry, relative to the genome-wide baseline.
#'
#' LDA score is the total amount of genome in LDA with each SNP
#' (measured in recombination map distance), which is useful for detecting the
#' signal of “recombinant favouring selection”.
#'
#' The codes for LDA and LDAS are hosted at \url{https://github.com/YaolingYang/LDAandLDAscore}.
#'
#' @references Barrie W, Yang Y, Attfield K E, et al. Genetic risk for Multiple Sclerosis originated in Pastoralist Steppe populations. bioRxiv (2022).
#' @importFrom methods is
"_PACKAGE"
#> [1] "_PACKAGE"
