% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getgobp.R
\name{get.W}
\alias{get.W}
\title{Record genes W}
\usage{
get.W(graph, laresult, z.matrix, cutoff, k = 2)
}
\arguments{
\item{graph}{The graph of gene network.}

\item{laresult}{The result of lascouting which finds the liquid association scouting genes.}

\item{z.matrix}{A matrix representing gene Z (selected scouting genes). Row names are the gene id in gene network.}

\item{cutoff}{The threshold to find LA scouting genes.}

\item{k}{An Integer giving the order of the network.}
}
\value{
A table records the intermediate result of Gene Ontology Biological Process which contains ego gene X, genes within k steps of X,
the liquid association scouting genes of x and genes W.Each x occupies a row.
}
\description{
\code{get.W()} creates a table to record Gene Ontology Biological Process mapping results.  Every gene x takes a row.
}
\details{
\code{get.W()} generates a result file of ego gene X, genes within k steps of X,
the liquid association scouting genes of x and genes W.Every gene x takes a row in the table.
}
\examples{
\dontrun{
laresult <- lascouting(g,m,k=2,n.cores=4)
get.W(g,laresult,z,cutoff=0.8,k=2)}
}

