% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{query_lagos_names}
\alias{query_lagos_names}
\title{Query LAGOSNE names}
\usage{
query_lagos_names(dt, grep_string, scale = NA)
}
\arguments{
\item{dt}{data.frame output of \code{\link[LAGOSNE]{lagosne_load}}}

\item{grep_string}{character search string to grep to table column names}

\item{scale}{character filter results by one of:
\itemize{
    \item county
    \item edu
    \item hu4
    \item hu8
    \item hu12
    \item state
}}
}
\description{
Return a vector of table names whose associated tables have
 columns that grep to query.
}
\examples{
\dontrun{
dt <- lagosne_load("1.087.1")
query_lagos_names(dt, "_dep_")
query_lagos_names(dt, "_dep_", "hu4")
query_lagos_names(dt, "chla")
query_lagos_names(dt, "secchi")
query_lagos_names(dt, "conn")
}
}
