% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koboconnect.R
\name{kobo_export_create}
\alias{kobo_export_create}
\title{Create an export}
\usage{
kobo_export_create(
  url = "eu.kobotoolbox.org",
  uname = "",
  pwd = "",
  assetid = "",
  type = "csv",
  all = "false",
  lang = "_default",
  hierarchy = "false",
  include_grp = "true",
  grp_sep = "/",
  multi_sel = "both",
  fields = NULL,
  media_url = "true",
  sub_ids = NULL,
  qry = NULL,
  flatten = "true",
  sleep = 2
)
}
\arguments{
\item{url}{The `[url]` of kobotoolbox Default is "eu.kobotoolbox.org".}

\item{uname}{is username of your kobotoolbox account}

\item{pwd}{is the password of the account}

\item{assetid}{is the id of the asset for which the export is to be created}

\item{type}{specifies the export format. Valid formats include "csv","xls", "spss_labels" and "geojson"}

\item{all}{takes logical value in string format. Used to specify whether fields from all form versions will be included in the export.Acceptable values are "true" or "false". Default value is "false".}

\item{lang}{takes the language. For e.g. "English (en)". For "XML Values as headers", use '_xml'.}

\item{hierarchy}{takes logical value in string format. Used to specify whether the group hierarchy will be displayed in labels. Acceptable values are "true" or "false". Default value is "false".}

\item{include_grp}{defines whether or not to include groups. Default value is "true".}

\item{grp_sep}{is the group separator. Default value is "/".}

\item{multi_sel}{is used to specify the display of multiple_select-type responses. Valid inputs include "both", "summary" or "details". Default is "both".}

\item{fields}{is an array of column names to be included in the export (including their group hierarchy). Valid inputs include:
An array containing any string value that matches the XML column name,
An empty array which will result in all columns being included,
If "fields" is not included in the "export_settings", all columns will be included in the export}

\item{media_url}{This will include an additional column for media-type questions ("question_name_URL") with the URL link to the hosted file. Valid inputs are "true" or "false". Default value is true.}

\item{sub_ids}{is an array of submission ids that will filter exported submissions to only the specified array of ids. Valid inputs include an array containing integer values or an empty array.#'}

\item{qry}{is a JSON object containing a Mongo filter query for filtering exported submissions. Valid inputs include
a JSON object containing a valid Mongo query or An empty JSON object (no filtering)}

\item{flatten}{is a is a boolean (in form of string) value and only relevant when exporting to "geojson" format. Valid inputs are "true" and "false"}

\item{sleep}{is the sleep time between API actions. For example, it takes time to download an export. But R does not wait for the download to finish before going to next step. Hence the need to provide a break between consecutive API actions. Default value is 2 (seconds).}
}
\value{
The function creates an export, prints and returns the URL of the export created
}
\description{
`kobo_export_create` is a wrapper for kobotoolbox API `https://[url]/exports/..`
}
\details{
The function creates an export of survey data. If successful, returns the URL of the data that can be directly downloaded/read/imported in R.
}
