% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/next.comb.kb.R
\name{next.comb.kb}
\alias{next.comb.kb}
\title{Find the Next Dose Combination}
\usage{
next.comb.kb(
  target,
  npts,
  ntox,
  dose.curr,
  n.earlystop = 100,
  marginL = 0.05,
  marginR = 0.05,
  cutoff.eli = 0.95,
  extrasafe = FALSE,
  offset = 0.05
)
}
\arguments{
\item{target}{The target dose-limiting toxicity (DLT) rate.}

\item{npts}{A \code{J*K} matrix \code{(J<=K)} containing the number of
patients treated at each dose combination.}

\item{ntox}{A \code{J*K} matrix \code{(J<=K)} containing the number of
patients who experienced a dose-limiting toxicity at each dose
combination.}

\item{dose.curr}{The current dose combination, i.e., the dose combination that was used to treat the most recently enrolled cohort of patients.}

\item{n.earlystop}{The early stopping parameter. If the number of patients
treated at the current dose reaches \code{n.earlystop}, then we 
stop the trial and select the MTD based on the observed
data.\cr
The default value is 100.}

\item{marginL}{The difference between the target and the lower limit of the
"target key" (proper dosing interval) to be defined.\cr
The default is 0.05.}

\item{marginR}{The difference between the target and the upper limit of the
"target key" (proper dosing interval) to be defined.\cr
The default is 0.05.}

\item{cutoff.eli}{The cutoff value to eliminate an overly toxic dose and all
higher doses for safety.\cr
The default value is 0.95.}

\item{extrasafe}{Set \code{extrasafe=TRUE} to impose a stricter
stopping rule.\cr
The default is FALSE.}

\item{offset}{A small positive number (between 0 and 0.5) to control how
strict the stopping rule is when \code{extrasafe=TRUE}. A
larger value leads to a stricter stopping rule.\cr
The default value is 0.05.}
}
\value{
This function returns the recommended dose for treating the next
  cohort of patients (\code{$next_dc}).
}
\description{
This function determines the dose combination for the next cohort of patients in
drug-combination trials.
}
\details{
Given the observed data thus far, this function determines the dose
combination for treating the next cohort of new patients. The observed data
are as follows: the number of patients treated at each dose combination (\code{npts}), the number of patients who experienced dose-limiting toxicities (DLTs)
at each dose combination (\code{ntox}) and the level of the current
dose (\code{dose.curr}). The number of patients for doses that have not been used in the trial is zero.
}
\section{Uses}{

This function uses \code{\link{get.boundary.comb.kb}}.
}

\examples{
### Drug-combination trial ###

n <- matrix(c(3, 0, 0, 0, 0,
              7, 6, 0, 0, 0,
              0, 0, 0, 0, 0), ncol=5, byrow=TRUE)
y <- matrix(c(0, 0, 0, 0, 0,
              1, 1, 0, 0, 0,
              0, 0, 0, 0, 0), ncol=5, byrow=TRUE)

nxt.comb <- next.comb.kb(target=0.3, npts=n, ntox=y, dose.curr=c(2, 2))
summary.kb(nxt.comb)

}
\references{
Yan F, Mandrekar SJ, Yuan Y. Keyboard: A Novel Bayesian Toxicity Probability
Interval Design for Phase I Clinical Trials.
\emph{Clinical Cancer Research}. 2017; 23:3994-4003.
http://clincancerres.aacrjournals.org/content/23/15/3994.full-text.pdf

Pan H, Lin R, Yuan Y. Keyboard design for phase I drug-combination trials.
\emph{Contemporary Clinical Trials}. 2020.
https://doi.org/10.1016/j.cct.2020.105972
}
\seealso{
Other drug-combination functions: 
\code{\link{get.boundary.comb.kb}()},
\code{\link{get.oc.comb.kb}()},
\code{\link{select.mtd.comb.kb}()}
}
\author{
Hongying Sun, Li Tang, and Haitao Pan
}
\concept{drug-combination functions}
