% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kspmControl.R
\name{kspmControl}
\alias{kspmControl}
\title{Control various aspects of the optimisation problem}
\usage{
kspmControl(interval.upper = NA, interval.lower = NA, trace = FALSE,
  optimize.tol = .Machine$double.eps^0.25, NP = NA, itermax = 500,
  CR = 0.5, F = 0.8, initialpop = NULL, storepopfrom = itermax + 1,
  storepopfreq = 1, p = 0.2, c = 0,
  reltol = sqrt(.Machine$double.eps), steptol = itermax,
  parallel = FALSE)
}
\arguments{
\item{interval.upper}{integer or vetor of initial maximum value(s) allowed for parameter(s)}

\item{interval.lower}{integer or vetor of initial maximum value(s) allowed for parameter(s)}

\item{trace}{boolean. If TRUE parameters value at each iteration are displayed.}

\item{optimize.tol}{if \link[stats]{optimize} function is used. See \link[stats]{optimize}}

\item{NP}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{itermax}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{CR}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{F}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{initialpop}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{storepopfrom}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{storepopfreq}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{p}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{c}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{reltol}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{steptol}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}

\item{parallel}{if \link[DEoptim]{DEoptim} function is used. See \link[DEoptim]{DEoptim.control}}
}
\value{
\code{search.parameters} is an iterative algorithm estimating model parameters and returns the following components:
 \item{lambda}{tuning parameters for penalization.}
 \item{beta}{vector of coefficients associated with linear part of the model, the size being the number of variable in linear part (including an intercept term).}
 \item{alpha}{vector of coefficients associated with kernel part of the model, the size being the sample size.}
 \item{Ginv}{a matrix used in several calculations. \eqn{Ginv = (\lambda I + K)^{-1}}{Ginv = (lambda I + K)^(-1)}.}
}
\description{
Allow the user to set some characteristics of the optimisation algorithm
}
\details{
When only one hyperparameter should be estimated, the optimisation problem calls the \link[stats]{optimize} function from \code{stats} basic package. Otherwise, it calls the \link[DEoptim]{DEoptim} function from the package \code{DEoptim}. In both case, the parameters are choosen among the initial interval defined by \code{interval.lower} and \code{interval.upper}.
}
\seealso{
link get.parameters for computation of parameters at each iteration
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
