% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{scorefunctiongmm}
\alias{scorefunctiongmm}
\title{Score function for given GMM : calculates score function dlogp(x)/dx
for a given Gaussian Mixture Model}
\usage{
scorefunctiongmm(model = NULL, X = NULL)
}
\arguments{
\item{model}{: The Gaussian Mixture Model}

\item{X}{(n by d): The dataset of interest,
where n is the number of samples and d is the dimension}
}
\value{
y : The score computed by the given function
}
\description{
Score function for given GMM : calculates score function dlogp(x)/dx
for a given Gaussian Mixture Model
}
\examples{
# Compute score for a given gaussianmixture model and dataset
model <- gmm()
X <- rgmm(model)
score <- scorefunctiongmm(model=model, X=X)
}

