% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRparas.R
\name{LRparas}
\alias{LRparas}
\title{Calculating parameters in LR}
\usage{
LRparas(
  AB,
  af = NULL,
  rare = NULL,
  allelename = FALSE,
  stepwisePI = FALSE,
  bred = FALSE,
  mu = 0.002
)
}
\arguments{
\item{AB}{Genotypes of two individuals of each case, which should be data.frame with 4 columns (2 for each individual) and \code{ss} rows, where \code{ss} stand for sample size;}

\item{af}{name of allele frequency matrix, a data.frame of 1 column containing frequencies with allele names being row names}

\item{rare}{frequency of rare allele on the locus}

\item{allelename}{if TRUE, the input genotype data would be regarded as allelenames, otherwise, the position in the af matrix}

\item{stepwisePI}{If TRUE, empirical decreasing model of STR mutation would be taken when paternity index is needed to be calculated, otherwise, mutation rate would be taken as PImu if IBS=0 between an alleged PC pair.}

\item{bred}{if TRUE, parameters used in the calculation of LR in inbred relationship would be calculated}

\item{mu}{mutation rate for PI calculation, with a default of 0.002}
}
\value{
a data frame with multiple column and ss rows, containing different types of parameters used in different LR calculation according to argument settings
}
\description{
Counting and calculating parameters used in the calculation process of different pairwise LR calculation
}
\details{
Note that LR elements are in their original values instead of log10 values used in other functions.
}
\examples{
af = FortytwoSTR$afmatrix[[1]]
AB = pairsimu(af = af,ss = 10000,delta = c(0,1,0),allelename = FALSE)
LRelements<-LRparas(AB=AB, af=af, rare=FortytwoSTR$rare[1],allelename=FALSE,
  stepwisePI=TRUE,bred=TRUE)

}
