% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JointAI.R
\name{sharedParams}
\alias{sharedParams}
\title{Parameters used by several functions in JointAI}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{no_model}{optional; vector of names of variables for which no model
should be specified.
Note that this is only possible for completely observed
variables and implies the assumptions of independence between
the excluded variable and the incomplete variables.}

\item{timevar}{name of the variable indicating the time of the measurement of
a time-varying covariate in a proportional hazards survival
model (also in a joint model).
The variable specified in
"timevar" will automatically be added to "no_model".}

\item{assoc_type}{named vector specifying the type of the association used
for a time-varying covariate in the linear predictor of the
survival model when using a "JM" model.
Implemented options are "underl.value"
(linear predictor; default for covariates modelled using a
Gaussian, Gamma, beta or log-normal distribution)
covariates) and "obs.value" (the observed/imputed value;
default for covariates modelled using other distributions).}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC
sample). Follows the same principle as the argument
\code{monitor_params} in
\code{\link[JointAI:model_imp]{*_imp}}.}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{n.adapt}{number of iterations for adaptation of the MCMC samplers
(see \code{\link[rjags]{adapt}})}

\item{n.iter}{number of iterations of the MCMC chain (after adaptation;
see \code{\link[rjags]{coda.samples}})}

\item{n.chains}{number of MCMC chains}

\item{quiet}{logical; if \code{TRUE} then messages generated by
\strong{rjags} during compilation as well as the progress bar
for the adaptive phase will be suppressed,
(see \code{\link[rjags]{jags.model}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{nrow}{optional; number of rows in the plot layout;
automatically chosen if unspecified}

\item{ncol}{optional; number of columns in the plot layout;
automatically chosen if unspecified}

\item{use_ggplot}{logical; Should ggplot be used instead of the base
graphics?}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{xlab, ylab}{labels for the x- and y-axis}

\item{idvars}{name of the column that specifies the multi-level grouping
structure}

\item{ridge}{logical; should the parameters of the main model be penalized
using ridge regression? Default is \code{FALSE}}

\item{seed}{optional; seed value (for reproducibility)}

\item{ppc}{logical: should monitors for posterior predictive checks be
set? (not yet used)}
}
\description{
Parameters used by several functions in JointAI
}
