% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predDF}
\alias{predDF}
\alias{predDF.formula}
\alias{predDF.JointAI}
\title{Create a new dataframe for prediction}
\usage{
predDF(...)

\method{predDF}{formula}(formula, dat, var, ...)

\method{predDF}{JointAI}(object, var, ...)
}
\arguments{
\item{...}{optional, additional arguments (currently not used)}

\item{formula}{model formula (only fixed effects)}

\item{dat}{original data}

\item{var}{name of variable that should be varying}

\item{object}{object inheriting from class \code{JointAI}}
}
\description{
Build a \code{data.frame} for prediction, where one variable
varies and all other variables are set to the reference value (median for
continuous variables.)
}
\examples{
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
newDF <- predDF(mod, var = "C2")

}
\seealso{
\code{\link{predict.JointAI}}, \code{\link{lme_imp}}, \code{\link{glm_imp}},
          \code{\link{lm_imp}}
}
