/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.ClassList;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.omegahat.Environment.IO.DirectoryFilter;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.System.Globals;
import org.omegahat.Environment.Tools.ClassList.ArchiveClassList;
import org.omegahat.Environment.Tools.ClassList.ClassFileFilter;
import org.omegahat.Environment.Utils.OrderedTable;

public class ObjectList
extends OrderedTable {
    protected FilenameFilter class_filter = new ClassFileFilter();
    protected DirectoryFilter dir_filter = new DirectoryFilter(true);
    protected File file = null;
    protected long compute_time = 0L;
    protected boolean recursive = true;
    protected boolean archive = false;
    protected boolean doneSearch = false;
    public static String fileSeparator = ObjectList.fileSeparator();
    protected static boolean issuedWarning = false;
    public static boolean verbose = false;

    public ObjectList() {
    }

    public ObjectList(File file) {
        this.file(file);
    }

    public Object add(ZipEntry zipEntry) {
        if (!zipEntry.getName().endsWith(".class")) {
            return null;
        }
        Object object = zipEntry;
        if (!zipEntry.isDirectory()) {
            if (this.recursive()) {
                ArchiveClassList archiveClassList;
                String string = this.getDirectory(zipEntry.getName());
                if (!this.containsKey(string)) {
                    archiveClassList = new ArchiveClassList();
                    archiveClassList.file(this.file(), true);
                    this.add(archiveClassList, string);
                } else {
                    archiveClassList = (ArchiveClassList)this.get(string);
                }
                if (string != null && string != "") {
                    archiveClassList.add(zipEntry, false);
                    object = archiveClassList;
                } else {
                    object = this.add(zipEntry);
                }
            } else {
                object = this.add(zipEntry);
            }
        }
        return object;
    }

    public Object add(ZipEntry zipEntry, boolean bl) {
        if (!bl) {
            return super.add(zipEntry);
        }
        return this.add(zipEntry);
    }

    public void addElement(Object object) {
        this.add(object);
    }

    public boolean archive(boolean bl) {
        this.archive = bl;
        return this.isArchive();
    }

    public boolean checkIsArchive(String string) {
        try {
            new ZipFile(string);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public long computeTime() {
        return this.computeTime(true);
    }

    protected long computeTime(boolean bl) {
        if (bl) {
            this.compute_time = System.currentTimeMillis();
        }
        return this.compute_time;
    }

    public DirectoryFilter directoryFilter() {
        return this.dir_filter;
    }

    public DirectoryFilter directoryFilter(DirectoryFilter directoryFilter) {
        this.dir_filter = directoryFilter;
        return this.directoryFilter();
    }

    public boolean doneSearch() {
        return this.doneSearch;
    }

    protected boolean doneSearch(boolean bl) {
        this.doneSearch = bl;
        return this.doneSearch();
    }

    public Vector entries() {
        if (!this.doneSearch() || this.sourceIsNewer()) {
            this.lookup();
        }
        return this.ordered();
    }

    public File file() {
        return this.file;
    }

    public File file(File file) {
        this.file = file;
        this.archive(this.checkIsArchive(file.toString()));
        return this.file();
    }

    public File file(File file, boolean bl) {
        this.file(file);
        if (bl) {
            this.doneSearch(true);
            this.computeTime(true);
        }
        return this.file();
    }

    public static String fileSeparator() {
        if (fileSeparator == null) {
            fileSeparator = System.getProperty("file.separator");
        }
        return fileSeparator;
    }

    public Object find(String string) {
        Object object = null;
        String string2 = null;
        Enumeration enumeration = this.entries().elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof ZipEntry) {
                string2 = ((ZipEntry)object).getName();
            } else if (object instanceof File) {
                string2 = ((File)object).toString();
            } else if (object instanceof String) {
                string2 = (String)object;
            } else {
                System.out.println("Object not expected: " + object.getClass().getName());
                new Exception().printStackTrace();
                continue;
            }
            if (!this.matchesClassName(string, string2)) continue;
            return object;
        }
        return null;
    }

    public String getDirectory(String string) {
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public boolean isArchive() {
        return this.archive;
    }

    public boolean issuedWarning() {
        return issuedWarning;
    }

    public boolean issuedWarning(boolean bl) {
        issuedWarning = bl;
        return this.issuedWarning();
    }

    protected int lookup() {
        int n;
        if (this.file() == null) {
            return -1;
        }
        this.computeTime();
        this.doneSearch(true);
        if (this.file().isDirectory()) {
            n = this.lookupDirectory(this.file());
        }
        if (this.isArchive()) {
            n = this.lookupArchive(this.file());
        } else {
            this.warnDirectory(this.file());
            n = -3;
        }
        return n;
    }

    public int lookupArchive(File file) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this.file().toString());
        }
        catch (IOException iOException) {
            this.warn("Archive file in classpath does not exist " + file);
            return -2;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
        return this.size();
    }

    protected int lookupDirectory() {
        int n = this.lookupDirectory(this.file());
        return n;
    }

    protected int lookupDirectory(File file) {
        String[] stringArray = null;
        stringArray = file.list(this.class_filter);
        if (stringArray != null && stringArray.length > 0) {
            String string = file.toString();
            if (this.file().toString().length() < string.length()) {
                string = string.substring(this.file().toString().length() + 1, string.length());
            }
            if (string != "") {
                string = String.valueOf(string) + System.getProperty("file.separator", "/").charAt(0);
            }
            this.processDirectoryClasses(stringArray, string, file);
        }
        if ((stringArray = file.list(this.dir_filter)) != null) {
            this.processSubDirectories(stringArray, file);
        }
        return this.size();
    }

    public boolean matchesClassName(String string, String string2) {
        boolean bl = false;
        if (string2.endsWith(string)) {
            bl = string2.equals(string) || string2.charAt(string2.length() - string.length() - 1) == (this.isArchive() ? (char)'/' : ObjectList.fileSeparator().charAt(0));
        }
        return bl;
    }

    public ObjectList newSubList() throws IllegalAccessException, InstantiationException {
        return (ObjectList)this.getClass().newInstance();
    }

    protected ObjectList processDirectoryClasses(String[] stringArray, String string, File file) {
        ObjectList objectList = this;
        if (this.recursive()) {
            try {
                objectList = this.newSubList();
                objectList.file(file, true);
            }
            catch (Exception exception) {
                System.err.println("Can't instantiate new sub-list of class " + this.getClass());
            }
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            objectList.add(String.valueOf(string) + stringArray[n2]);
            ++n2;
        }
        if (this.recursive()) {
            objectList.doneSearch(true);
            String string2 = string;
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.add(objectList, string2);
        }
        return objectList;
    }

    protected int processSubDirectories(String[] stringArray, File file) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.lookupDirectory(new File(String.valueOf(file.toString()) + "/" + stringArray[n2]));
            ++n2;
        }
        return n;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public boolean recursive(boolean bl) {
        this.recursive = bl;
        return this.recursive();
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public boolean refresh(boolean bl) {
        this.doneSearch(false);
        if (bl) {
            this.entries();
        }
        return true;
    }

    public boolean sourceIsNewer() {
        return this.file().lastModified() >= this.computeTime(false);
    }

    public String toClassName(String string) {
        return string;
    }

    public void warn(String string) {
        if (!this.issuedWarning()) {
            Evaluator evaluator = null;
            try {
                evaluator = Globals.evaluator(false);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (evaluator != null) {
                evaluator.warning(String.valueOf(this.getClass().getName()) + ":: " + string);
            } else {
                System.err.println(String.valueOf(this.getClass().getName()) + ": " + string);
            }
            this.issuedWarning(true);
        }
    }

    public void warnDirectory(File file) {
        if (!file.toString().startsWith(System.getProperty("java.home"))) {
            this.warn("`" + this.file() + "' is neither a directory or an archive " + this.file().getClass());
        }
    }
}

