% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{.quantilePercentiles}
\alias{.quantilePercentiles}
\title{Internal Function to Calculate Quantiles}
\usage{
.quantilePercentiles(data, LL = 0.1, UL = 0.9, na.rm = TRUE, cut = 4L)
}
\arguments{
\item{data}{A dataset of predicted and residual values.
Assumed from some sort of (probably parametric) model.}

\item{LL}{The lower limit for prediction. Defaults to
\code{.1} to give the 10th percentile.}

\item{UL}{The upper limit for prediction. Defaults to
\code{.9} to give the 90th percentile.}

\item{na.rm}{A logical whether to remove missing values.
Defaults to \code{TRUE}}

\item{cut}{An integer, how many unique predicted values
there have to be at least for it to use quantile regression
or treat the predicted values as discrete.
Defaults to 4.}
}
\value{
A data.table with the scores and predicted LL and UL,
  possibly missing if quantile regression models do not
  converge.
}
\description{
Function calculates smoothing spline quantiles
or linear quantiles as a fall back. Not intended for general use.
Expected predicted and residual data.
Exported to support related packages.
}
