% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styler.R
\name{APAStyler.modelTest.vglm}
\alias{APAStyler.modelTest.vglm}
\title{APAStyler method for model tests from a vglm multinomial model}
\usage{
\method{APAStyler}{modelTest.vglm}(object, format = list(FixedEffects =
  c("\%s\%s [\%s, \%s]"), EffectSizes =
  c("Chi-square (df=\%s) = \%s, \%s")), digits = 2,
  pcontrol = list(digits = 3, stars = TRUE, includeP = FALSE, includeSign
  = FALSE, dropLeadingZero = TRUE), OR = TRUE, ...)
}
\arguments{
\item{object}{A \code{modelTest.vglm} class object,
results from running \code{modelTest()} function on a
class \code{vglm} object with a multinomial family}

\item{format}{A list giving the formatting style to be used for
the fixed effects and effect sizes.}

\item{digits}{A numeric value indicating the number of digits to print.
This is still in early implementation stages and currently does not
change all parts of the output (which default to 2 decimals per
APA style).}

\item{pcontrol}{A list controlling how p values are formatted.}

\item{OR}{a logical value whether to report odds ratios and
95 percent confidence intervals, if \code{TRUE}, or
regression coefficients on the logit scale with standard
errors, if \code{FALSE}.}

\item{...}{Additional arguments.}
}
\value{
Styled results.
}
\description{
APAStyler method for model tests from a vglm multinomial model
}
\examples{
mtcars$cyl <- factor(mtcars$cyl)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
mt <- modelTest(m)

APAStyler(mt)

APAStyler(mt, OR = FALSE)

## clean up
rm(m, mt, mtcars)

\dontrun{
mtcars$cyl <- factor(mtcars$cyl)
mtcars$am <- factor(mtcars$am)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
APAStyler(modelTest(m))

m <- VGAM::vglm(cyl ~ scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
APAStyler(modelTest(m))

m2 <- VGAM::vglm(cyl ~ factor(vs) * scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
APAStyler(modelTest(m2))

m <- VGAM::vglm(Species ~ Sepal.Length,
  family = VGAM::multinomial(), data = iris)
APAStyler(modelTest(m))

set.seed(1234)
sampdata <- data.frame(
  Outcome = factor(sample(letters[1:3], 20 * 9, TRUE)),
  C1 = rnorm(20 * 9),
  D3 = sample(paste0("L", 1:3), 20 * 9, TRUE))

m <- VGAM::vglm(Outcome ~ factor(D3),
  family = VGAM::multinomial(), data = sampdata)
APAStyler(modelTest(m))

m <- VGAM::vglm(Outcome ~ factor(D3) + C1,
  family = VGAM::multinomial(), data = sampdata)
APAStyler(modelTest(m))
}
}
