% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{circle_data}
\alias{circle_data}
\title{Simulate data from the circle model.}
\usage{
circle_data(n = 500, inner_r = 8, outer_r = 28)
}
\arguments{
\item{n}{Number of points to simulate.}

\item{inner_r}{Inner radius of annulus.}

\item{outer_r}{Outer radius of annulus.}
}
\value{
Returns a list with the following components:

\item{y}{Vector of simulated response in \code{c(-1,1)}.}
\item{X}{An \code{n}x\code{2} matrix of simulated predictors.}
\item{p}{The true conditional probability \eqn{p(y=1|x)}.}
}
\description{
Simulate draws from a bernoulli distribution over \code{c(-1,1)}.  First, the
predictors \eqn{x} are drawn i.i.d. uniformly over the square in the two dimensional
plane centered at the origin with side length \code{2*outer_r}, and then the
response is drawn according to \eqn{p(y=1|x)}, which depends
on \eqn{r(x)}, the euclidean norm of \eqn{x}.  If
\eqn{r(x) \le inner_r}, then \eqn{p(y=1|x) = 1}, if \eqn{r(x) \ge outer_r}
then \eqn{p(y=1|x) = 1}, and \eqn{p(y=1|x) = (outer_r - r(x))/(outer_r - inner_r)}
when \eqn{inner_r <= r(x) <= outer_r}.  See Mease (2008).
}
\examples{
# Generate data from the circle model
set.seed(111)
dat = circle_data(n = 500, inner_r = 1, outer_r = 5)

\dontrun{
# Visualization of conditional probability p(y=1|x)
inner_r = 0.5
outer_r = 1.5
x = seq(-outer_r, outer_r, by=0.02)
radius = sqrt(outer(x^2, x^2, "+"))
prob = ifelse(radius >= outer_r, 0, ifelse(radius <= inner_r, 1,
             (outer_r-radius)/(outer_r-inner_r)))
image(x, x, prob, main='Probability Density: Circle Example')
}

}
\references{
Mease, D., Wyner, A. and Buha, A. (2007). Costweighted
boosting with jittering and over/under-sampling:
JOUS-boost. J. Machine Learning Research 8 409-439.
}
