% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ps2DGLM.R
\name{plot.ps2dglm}
\alias{plot.ps2dglm}
\title{Plotting function for \code{ps2DGLM}}
\usage{
\method{plot}{ps2dglm}(x, ..., xlab = " ", ylab = " ", Resol = 100, se = 2)
}
\arguments{
\item{x}{the P-spline object, usually from \code{ps2DGLM}.}

\item{...}{other parameters.}

\item{xlab}{label for the x-axis, e.g. "my x" (quotes required).}

\item{ylab}{label for the y-axis, e.g. "my y" (quotes required).}

\item{Resol}{resolution for plotting, default \code{Resol = 100}.}

\item{se}{a scalar, e.g. \code{se = 2} to produce twice se surfaces,
set \code{se} > 0 (or set \code{se = 0} to supress).}
}
\value{
\item{Plot}{a plot of the mean (inverse link) 2D P-spline (GLM) smooth surface.}
}
\description{
Plotting function for 2D P-spline (GLM) smooothing
(using \code{ps2DGLM} with \code{class ps2dglm}).
}
\examples{
library(fields)
library(JOPS)
# Extract data
library(rpart)
Kyphosis <- kyphosis$Kyphosis
Age <- kyphosis$Age
Start <- kyphosis$Start
y <- 1 * (Kyphosis == "present") # make y 0/1
fit <- ps2DGLM(
  Data = cbind(Start, Age, y),
  Pars = rbind(c(1, 18, 10, 3, .1, 2), c(1, 206, 10, 3, .1, 2)),
  family = "binomial"
)
plot(fit, xlab = "Start", ylab = "Age")
#title(main = "Probability of Kyphosis")
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
