/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRPackageInstaller
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = 3654839767863743685L;
    private String[] packages = null;
    private JList pkgList;
    private final JButton install = new JButton("Install");
    private final JButton close = new JButton("Close");
    private String type = "binaries";
    private final String current = RController.getCurrentPackages();
    private static JGRPackageInstaller instance;

    private JGRPackageInstaller(String[] stringArray, String string) {
        super("Package Installer", false, 154);
        this.type = string;
        this.packages = stringArray;
        String[] stringArray2 = new String[]{"~Window", "0"};
        EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray2);
        this.close.setActionCommand("close");
        this.close.addActionListener(this);
        this.install.setActionCommand("install");
        this.install.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.install);
        jPanel.add(this.close);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.pkgList = new JList<String>(this.packages);
        this.getContentPane().add((Component)new JScrollPane(this.pkgList), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.pkgList.setCellRenderer(new PkgCellRenderer());
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.close);
        this.setMinimumSize(new Dimension(150, 250));
        this.setLocation(200, 10);
        this.setSize(200, 400);
        this.setResizable(false);
    }

    public void refresh(String[] stringArray, String string) {
        this.type = string;
        this.packages = stringArray;
        this.pkgList = new JList<String>(this.packages);
        this.pkgList.setCellRenderer(new PkgCellRenderer());
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    private void installPkg() {
        String string = null;
        for (int i = 0; i < JGR.RLIBS.length; ++i) {
            if (!this.checkLibPaths(JGR.RLIBS[i])) continue;
            string = JGR.RLIBS[i];
            break;
        }
        if (string == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose Installation Directory");
            int n = jFileChooser.showOpenDialog((Component)((Object)this));
            if (n == 1) {
                return;
            }
            if (jFileChooser.getSelectedFile() != null) {
                string = jFileChooser.getSelectedFile().toString();
            }
            if (!this.checkLibPaths(string)) {
                string = null;
            }
            if (string != null) {
                String[] stringArray = new String[JGR.RLIBS.length + 1];
                stringArray[0] = string;
                System.arraycopy(JGR.RLIBS, 0, stringArray, 1, JGR.RLIBS.length);
                JGR.RLIBS = stringArray;
                JGRPrefs.writePrefs(true);
                try {
                    JGR.eval(".libPaths(\"" + string + "\")");
                }
                catch (REngineException rEngineException) {
                    new ErrorMsg(rEngineException);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    new ErrorMsg(rEXPMismatchException);
                }
            }
        }
        if (string == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "JGR was unable to write to the library directory.\nPlease change your library path or get sufficient rights.", "Permisson denied", 0);
            return;
        }
        Object[] objectArray = this.pkgList.getSelectedValues();
        String string2 = "c(";
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length - 1; ++i) {
                string2 = string2 + "\"" + objectArray[i] + "\",";
            }
            string2 = string2 + "\"" + objectArray[objectArray.length - 1] + "\")";
            if (this.type.equals("binaries") && JGRPrefs.isMac) {
                JGR.MAINRCONSOLE.executeLater("install.packages(" + string2 + ",\"" + string + "\",type=\"mac.binary\")", true);
            } else {
                JGR.MAINRCONSOLE.executeLater("install.packages(" + string2 + ",\"" + string + "\")", true);
            }
        }
    }

    private boolean checkLibPaths(String string) {
        try {
            String string2 = string + "/JGR.test";
            if (System.getProperty("os.name").startsWith("Windows")) {
                string2 = string2.replace('/', '\\');
            }
            File file = new File(string2);
            file.createNewFile();
            file.delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "close" || string == "exit") {
            this.dispose();
        } else if (string == "install") {
            this.installPkg();
        }
    }

    public static void instAndDisplay(String[] stringArray, String string) {
        final String[] stringArray2 = stringArray;
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                if (instance == null) {
                    instance = new JGRPackageInstaller(stringArray2, string2);
                } else {
                    instance.refresh(stringArray2, string2);
                }
                instance.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    class PkgCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -8274314191764454898L;

        public PkgCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            if (JGRPackageInstaller.this.current.equals(object.toString())) {
                this.setBackground(bl ? Color.blue : Color.lightGray);
                this.setForeground(bl ? Color.lightGray : Color.black);
            } else {
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
            }
            return this;
        }
    }
}

