/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import jedit.syntax.FindReplaceDialog;
import jedit.syntax.InputHandler;
import jedit.syntax.JEditTextArea;
import jedit.syntax.RTokenMarker;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.editor.EditToolbar;
import org.rosuda.JGR.editor.RInputHandler;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.DocumentRenderer;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.util.RecentList;

public class Editor
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = -2281511772856410211L;
    JEditTextArea textArea = new JEditTextArea();
    JLabel modifiedStatus = new JLabel("   ");
    CaretListenerLabel cLabel = new CaretListenerLabel();
    private boolean modified = false;
    public static RecentList recentOpen;
    public JMenu recentMenu;
    private String fileName;

    public Editor() {
        this(null);
    }

    public Editor(String string) {
        this(string, true);
    }

    public Editor(String string, boolean bl) {
        super("Editor", false, 150);
        Object object;
        Object object2;
        this.setLayout(new BorderLayout());
        String[] stringArray = new String[]{"+", "File", "@NNew", "new", "@OOpen", "open", "#Open Recent", "", "@SSave", "save", "!SSave as", "saveas", "-", "@PPrint", "print", "-", "@QQuit", "quit", "+", "Edit", "@ZUndo", "undo", "!ZRedo", "redo", "-", "@XCut", "cut", "@CCopy", "copy", "@VPaste", "paste", "-", "@/Comment out", "commentcode", "@;Uncomment", "uncommentcode", "-", "!LShift Left", "shiftleft", "!RShift Right", "shiftright", "-", "@RRun Selection", "runselection", "Run all", "runall", "-", "@FFind", "find", "@GFind next", "findnext", "+", "Tools", "!IIncrease Font Size", "fontBigger", "!DDecrease Font Size", "fontSmaller", "~Window", "+", "Help", "R Help", "help", "~Preferences", "~About", "0"};
        EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray);
        JMenu jMenu = this.recentMenu = (JMenu)EzMenuSwing.getItem((JFrame)((Object)this), (String)"Open Recent");
        if (jMenu != null) {
            JMenuItem jMenuItem;
            int n;
            jMenu.removeAll();
            if (recentOpen == null) {
                recentOpen = new RecentList("JGR", "RecentOpenFiles", 8);
            }
            object2 = recentOpen.getShortEntries();
            object = recentOpen.getAllEntries();
            for (n = 0; n < ((String[])object2).length; ++n) {
                jMenuItem = new JMenuItem(object2[n]);
                jMenuItem.setActionCommand("recent:" + object[n]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            if (n > 0) {
                jMenu.addSeparator();
            }
            jMenuItem = new JMenuItem("Clear list");
            jMenuItem.setActionCommand("recent-clear");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            if (n == 0) {
                jMenuItem.setEnabled(false);
            }
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Editor.this.exit();
            }
        });
        this.textArea.getDocument().setTokenMarker(new RTokenMarker());
        object2 = new RInputHandler();
        ((RInputHandler)object2).addKeyBindings();
        this.textArea.setInputHandler((InputHandler)object2);
        this.textArea.addCaretListener(this.cLabel);
        this.textArea.setPreferredSize(new Dimension(600, 800));
        object = new JPanel(new FlowLayout(2));
        ((Container)object).add(this.modifiedStatus);
        ((Container)object).add(this.cLabel);
        this.add(this.textArea, "Center");
        this.add((Component)object, "South");
        this.pack();
        this.textArea.requestFocus();
        new EditToolbar((Frame)((Object)this), this);
        if (string != null) {
            this.fileName = string;
            this.openFile(string);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                Editor.this.setTitle(Editor.this.fileName);
            }
        });
        if (bl) {
            this.setVisible(true);
        }
        this.initPlacement();
        this.toFront();
        this.requestFocus();
        this.textArea.requestFocus();
    }

    public void dispose() {
        this.exit();
    }

    public boolean exit() {
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save File?", "Exit", 1, 3);
            if (n == 1) {
                super.dispose();
                return true;
            }
            if (n == 0 && this.saveFile()) {
                super.dispose();
                return true;
            }
            return false;
        }
        super.dispose();
        return true;
    }

    private boolean saveFile() {
        if (this.fileName == null || this.fileName.equals("")) {
            return this.saveFileAs();
        }
        this.setWorking(true);
        this.textArea.saveFile(this.fileName);
        this.setWorking(false);
        this.setTitle(this.fileName == null ? "Editor" : this.fileName);
        this.modified = false;
        this.setModified(false);
        return true;
    }

    public void setText(StringBuffer stringBuffer) {
        this.textArea.setText(stringBuffer.toString());
    }

    public void open() {
        this.openFile();
    }

    private void openFile() {
        this.openFile(null);
    }

    private void openFile(String string) {
        Object object;
        String string2 = string;
        if (string == null) {
            object = new FileSelector((Frame)((Object)this), "Open...", 0, JGRPrefs.workingDirectory);
            ((FileSelector)object).setVisible(true);
            if (((FileSelector)object).getFile() != null) {
                JGRPrefs.workingDirectory = ((FileSelector)object).getDirectory();
                string2 = JGRPrefs.workingDirectory + ((FileSelector)object).getFile();
            }
        } else {
            string2 = string;
        }
        if (string2 != null && string2.trim().length() > 0) {
            Object object2;
            this.setWorking(true);
            object = string2;
            if (recentOpen == null) {
                recentOpen = new RecentList("JGR", "RecentOpenFiles", 8);
            }
            recentOpen.addEntry((String)object);
            JMenu jMenu = this.recentMenu = (JMenu)EzMenuSwing.getItem((JFrame)((Object)this), (String)"Open Recent");
            if (jMenu != null) {
                JMenuItem jMenuItem;
                int n;
                jMenu.removeAll();
                object2 = recentOpen.getShortEntries();
                String[] stringArray = recentOpen.getAllEntries();
                for (n = 0; n < ((String[])object2).length; ++n) {
                    System.out.println(object2[n]);
                    jMenuItem = new JMenuItem(object2[n]);
                    jMenuItem.setActionCommand("recent:" + stringArray[n]);
                    jMenuItem.addActionListener(this);
                    jMenu.add(jMenuItem);
                }
                if (n > 0) {
                    jMenu.addSeparator();
                }
                jMenuItem = new JMenuItem("Clear list");
                jMenuItem.setActionCommand("recent-clear");
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                if (n == 0) {
                    jMenuItem.setEnabled(false);
                }
            }
            if (this.modified) {
                object2 = new Editor(null, false);
                ((Editor)object2).textArea.setText("");
                ((Editor)object2).textArea.loadFile(string2);
                ((Editor)object2).fileName = object;
                ((Editor)object2).modified = false;
                super.setModified(false);
                object2.setVisible(true);
                ((Editor)object2).setTitle(string2);
            } else {
                this.setWorking(true);
                this.textArea.setText("");
                this.textArea.loadFile((String)object);
                this.setVisible(true);
                this.fileName = object;
                this.setTitle(string2);
            }
            this.setWorking(false);
        }
    }

    private void newEditor() {
        Editor editor = new Editor();
        editor.setVisible(true);
    }

    public void setTitle(String string) {
        int n;
        int n2 = 1;
        if (System.getProperty("os.name").startsWith("Win")) {
            super.setTitle(string == null ? "Editor" : string);
            return;
        }
        try {
            n = this.getFontMetrics(this.getFont()).stringWidth(string);
        }
        catch (Exception exception) {
            super.setTitle(string == null ? "Editor" : string);
            return;
        }
        boolean bl = true;
        while (n > this.getWidth() - 100 && bl) {
            int n3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            int n4 = stringTokenizer.countTokens();
            string = !JGRPrefs.isMac ? stringTokenizer.nextElement() + "" + File.separator : File.separator;
            if (n2 > n4) {
                for (n3 = 1; n3 < n4 && stringTokenizer.hasMoreTokens(); ++n3) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                bl = false;
            } else {
                for (n3 = 1; n3 <= n4 && stringTokenizer.hasMoreTokens(); ++n3) {
                    if (n3 <= n4 / 2 - (n2 - n2 / 2) || n3 > n4 / 2 + n2 / 2) {
                        string = string + stringTokenizer.nextToken() + "" + (stringTokenizer.hasMoreTokens() ? File.separator : "");
                        continue;
                    }
                    string = string + "..." + File.separator;
                    stringTokenizer.nextToken();
                }
                bl = true;
            }
            n = this.getFontMetrics(this.getFont()).stringWidth(string);
            ++n2;
        }
        super.setTitle(string);
    }

    private boolean saveFileAs() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Save as...", 1, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fileSelector.getFile();
            return this.saveFile();
        }
        return false;
    }

    private void setModified(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Editor.this.modifiedStatus.setText(Editor.this.modified ? "Modified" : "");
            }
        });
    }

    public void print() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(this.textArea.getDocument());
    }

    public static void main(String[] stringArray) {
        Editor editor = new Editor();
        editor.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if ("about".equalsIgnoreCase(actionEvent.getActionCommand())) {
            new AboutDialog((JFrame)((Object)this));
        }
        if ("new".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.newEditor();
        }
        if ("open".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.openFile();
        }
        if ("save".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.saveFile();
        }
        if ("saveas".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.saveFileAs();
        }
        if ("copy".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.textArea.copy();
        }
        if ("cut".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.textArea.cut();
        }
        if ("paste".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.textArea.paste();
        }
        if ("undo".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.textArea.undo();
        }
        if ("redo".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.textArea.redo();
        }
        if ("find".equalsIgnoreCase(actionEvent.getActionCommand())) {
            FindReplaceDialog.findExt((Frame)((Object)this), this.textArea);
        }
        if ("findnext".equalsIgnoreCase(actionEvent.getActionCommand())) {
            FindReplaceDialog.findNextExt((Frame)((Object)this), this.textArea);
        }
        if ("fontBigger".equalsIgnoreCase(actionEvent.getActionCommand())) {
            FontTracker.current.setFontBigger();
        }
        if ("fontSmaller".equalsIgnoreCase(actionEvent.getActionCommand())) {
            FontTracker.current.setFontSmaller();
        }
        if (actionEvent.getActionCommand() == "commentcode") {
            if (this.textArea.getSelectedText() != null && this.textArea.getSelectedText().trim().length() > 0) {
                try {
                    this.textArea.commentSelection(true);
                }
                catch (BadLocationException badLocationException) {}
            }
        } else if (actionEvent.getActionCommand() == "uncommentcode" && this.textArea.getSelectedText() != null && this.textArea.getSelectedText().trim().length() > 0) {
            try {
                this.textArea.commentSelection(false);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (actionEvent.getActionCommand().startsWith("recent:")) {
            if (this.modified) {
                new Editor(actionEvent.getActionCommand().replaceFirst("recent:", ""));
            } else {
                this.fileName = actionEvent.getActionCommand().replaceFirst("recent:", "");
                this.openFile(this.fileName);
            }
        } else if (actionEvent.getActionCommand() == "preferences") {
            object = PrefDialog.showPreferences((JFrame)((Object)this));
            ((Window)object).setLocationRelativeTo(null);
            ((Dialog)object).setVisible(true);
        } else if (actionEvent.getActionCommand() == "print") {
            this.print();
        } else if (actionEvent.getActionCommand() == "recent-clear" && recentOpen != null && this.recentMenu != null) {
            this.recentMenu.removeAll();
            this.recentMenu.addSeparator();
            object = new JMenuItem("Clear list");
            ((AbstractButton)object).setActionCommand("recent-clear");
            ((AbstractButton)object).addActionListener(this);
            ((JMenuItem)object).setEnabled(false);
            this.recentMenu.add((JMenuItem)object);
            recentOpen.reset();
        }
        if (actionEvent.getActionCommand() == "help") {
            JGR.MAINRCONSOLE.executeLater("help.start()", false);
        }
        if (actionEvent.getActionCommand() == "shiftleft") {
            try {
                this.textArea.shiftSelection(-1);
            }
            catch (BadLocationException badLocationException) {}
        } else if (actionEvent.getActionCommand() == "shiftright") {
            try {
                this.textArea.shiftSelection(1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (actionEvent.getActionCommand() == "runall") {
            try {
                object = this.textArea.getText();
                if (((String)object).length() > 0) {
                    JGR.MAINRCONSOLE.executeLater(((String)object).trim(), true);
                }
            }
            catch (Exception exception) {}
        } else if (actionEvent.getActionCommand() == "runselection") {
            try {
                object = this.textArea.getSelectedText().trim();
                if (((String)object).length() > 0) {
                    JGR.MAINRCONSOLE.executeLater(((String)object).trim(), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ("quit".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.exit();
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        private static final long serialVersionUID = -4451331086216529945L;

        public void caretUpdate(CaretEvent caretEvent) {
            Editor.this.modified = true;
            Editor.this.setModified(Editor.this.modified);
            this.displayInfo(caretEvent);
        }

        protected void displayInfo(CaretEvent caretEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        int n = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getCaretPosition();
                        int n2 = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getText().lastIndexOf("\n", n - 1);
                        int n3 = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getText(0, n2 < 0 ? 0 : n2).length();
                        int n4 = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getLineOfOffset(((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getCaretPosition()) + 1;
                        CaretListenerLabel.this.setText(n4 + ":" + (n4 == 1 ? n + 1 : (n -= n3)) + "   ");
                    }
                    catch (Exception exception) {
                        new ErrorMsg(exception);
                    }
                }
            });
        }
    }
}

