% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorellipse.R
\name{scatterplot}
\alias{scatterplot}
\title{Create a scatter plot with error ellipses or crosses}
\usage{
scatterplot(
  xy,
  oerr = 3,
  show.numbers = FALSE,
  show.ellipses = 1,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  fit = "none",
  add = FALSE,
  empty = FALSE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  addcolourbar = TRUE,
  bg,
  cex,
  xlim = NULL,
  ylim = NULL,
  xlab,
  ylab,
  asp = NA,
  log = "",
  ...
)
}
\arguments{
\item{xy}{matrix with columns \code{X, sX, Y, sY(, rXY)}}

\item{oerr}{indicates whether the analytical uncertainties of the
    output are reported as:

\code{1}: 1\eqn{\sigma} absolute uncertainties.

\code{2}: 2\eqn{\sigma} absolute uncertainties.

\code{3}: absolute (1-\eqn{\alpha})\% confidence intervals, where
\eqn{\alpha} equales the value that is stored in
\code{settings('alpha')}.

\code{4}: 1\eqn{\sigma} relative uncertainties (\eqn{\%}).

\code{5}: 2\eqn{\sigma} relative uncertainties (\eqn{\%}).

\code{6}: relative (1-\eqn{\alpha})\% confidence intervals, where
\eqn{\alpha} equales the value that is stored in
\code{settings('alpha')}.}

\item{show.numbers}{logical flag (\code{TRUE} to show grain
numbers)}

\item{show.ellipses}{show the data as:

\code{0}: points

\code{1}: error ellipses

\code{2}: error crosses}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{clabel}{label for the colour scale}

\item{ellipse.fill}{Fill colour for the error ellipses. This can either be a single
colour or multiple colours to form a colour ramp. Examples:

a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.;

multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.;

a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.; or

a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))},
etc.

For empty ellipses, set \code{ellipse.col=NA}}

\item{ellipse.stroke}{the stroke colour for the error
ellipses. Follows the same formatting guidelines as
\code{ellipse.fill}}

\item{fit}{the output of \code{york()} (optional).}

\item{add}{if \code{TRUE}, adds the points and lines to the
existing plot.}

\item{empty}{set up an empty plot with the right axis limits to fit
the data}

\item{ci.col}{the fill colour for the confidence interval of the
intercept and slope.}

\item{line.col}{colour of the regression line}

\item{lwd}{line width of the regression line}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from the isochron age calculation.}

\item{omit.fill}{fill colour that should be used for the omitted
aliquots.}

\item{omit.stroke}{stroke colour that should be used for the
omitted aliquots.}

\item{addcolourbar}{add a colour bar to display the colours used to
\code{levels}}

\item{bg}{background colour for the plot symbols (only used if
\code{show.ellipses=0}).}

\item{cex}{plot symbol magnification.}

\item{xlim}{(optional) two-element vector with the x-axis limits}

\item{ylim}{(optional) two-element vector with the y-axis limits}

\item{xlab}{(optional) x-axis label (only used when
\code{add=FALSE})}

\item{ylab}{(optional) y-axis label (only used when
\code{add=FALSE})}

\item{asp}{the y/x aspect ratio, see `plot.window'.}

\item{log}{same as the eponymous argument to the generic
\code{plot} function.}

\item{...}{optional arguments to format the points and text.}
}
\description{
Takes bivariate data with (correlated) uncertainties as input and
produces a scatter plot with error ellipses or crosses as output.
(optionally) displays the linear fit on this diagram, and can show
a third variable as a colour scale.
}
\examples{
X <- c(1.550,12.395,20.445,20.435,20.610,24.900,
       28.530,50.540,51.595,86.51,106.40,157.35)
Y <- c(.7268,.7809,.8200,.8116,.8160,.8302,
       .8642,.9534,.9617,1.105,1.230,1.440)
sX <- X*0.02
sY <- Y*0.01
dat <- cbind(X,sX,Y,sY)
scatterplot(dat,fit=york(dat),show.ellipses=2)
}
