% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakfit.R
\name{peakfit}
\alias{peakfit}
\alias{peakfit.default}
\alias{peakfit.fissiontracks}
\alias{peakfit.UPb}
\alias{peakfit.PbPb}
\alias{peakfit.ArAr}
\alias{peakfit.KCa}
\alias{peakfit.ReOs}
\alias{peakfit.SmNd}
\alias{peakfit.RbSr}
\alias{peakfit.LuHf}
\alias{peakfit.ThU}
\alias{peakfit.UThHe}
\title{Finite mixture modelling of geochronological datasets}
\usage{
peakfit(x, ...)

\method{peakfit}{default}(x, k = "auto", sigdig = 2, log = TRUE,
  alpha = 0.05, ...)

\method{peakfit}{fissiontracks}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, alpha = 0.05, ...)

\method{peakfit}{UPb}(x, k = 1, type = 4, cutoff.76 = 1100,
  cutoff.disc = c(-15, 5), common.Pb = 0, exterr = TRUE,
  sigdig = 2, log = TRUE, alpha = 0.05, ...)

\method{peakfit}{PbPb}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, common.Pb = 0, alpha = 0.05, ...)

\method{peakfit}{ArAr}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, i2i = FALSE, alpha = 0.05, ...)

\method{peakfit}{KCa}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, i2i = FALSE, alpha = 0.05, ...)

\method{peakfit}{ReOs}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, i2i = TRUE, alpha = 0.05, ...)

\method{peakfit}{SmNd}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, i2i = TRUE, alpha = 0.05, ...)

\method{peakfit}{RbSr}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, i2i = TRUE, alpha = 0.05, ...)

\method{peakfit}{LuHf}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, i2i = TRUE, alpha = 0.05, ...)

\method{peakfit}{ThU}(x, k = 1, exterr = FALSE, sigdig = 2,
  log = TRUE, i2i = TRUE, alpha = 0.05, detritus = 0, ...)

\method{peakfit}{UThHe}(x, k = 1, sigdig = 2, log = TRUE,
  alpha = 0.05, ...)
}
\arguments{
\item{x}{either an \code{[n x 2]} matrix with measurements and
their standard errors, or an object of class
\code{fissiontracks}, \code{UPb}, \code{PbPb}, \code{ArAr},
\code{KCa}, \code{ReOs}, \code{SmNd}, \code{RbSr}, \code{LuHf},
\code{ThU} or \code{UThHe}}

\item{...}{optional arguments (not used)}

\item{k}{the number of discrete age components to be
sought. Setting this parameter to \code{'auto'} automatically
selects the optimal number of components (up to a maximum of 5)
using the Bayes Information Criterion (BIC).}

\item{sigdig}{number of significant digits to be used for any
legend in which the peak fitting results are to be displayed.}

\item{log}{take the logs of the data before applying the mixture
model?}

\item{alpha}{cutoff value for confidence intervals}

\item{exterr}{propagate the external sources of uncertainty into
the component age errors?}

\item{type}{scalar valueindicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), or the (Wetherill) concordia age
(\code{type}=5)}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{two element vector with the maximum and minimum
percentage discordance allowed between the
\eqn{^{207}}Pb/\eqn{^{235}}U and \eqn{^{206}}Pb/\eqn{^{238}}U
age (if \eqn{^{206}}Pb/\eqn{^{238}}U < \code{cutoff.76}) or
between the \eqn{^{206}}Pb/\eqn{^{238}}U and
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (if
\eqn{^{206}}Pb/\eqn{^{238}}U > \code{cutoff.76}).  Set
\code{cutoff.disc=NA} if you do not want to use this filter.}

\item{common.Pb}{apply a common lead correction using one of three
    methods:

\code{1}: use the Stacey-Kramers two-stage model to infer the initial
Pb-composition

\code{2}: use the isochron intercept as the initial Pb-composition

\code{3}: use the Pb-composition stored in
\code{settings('iratio','Pb207Pb206')} (if \code{x$format}<4) or
\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')} (if \code{x$format}>3)}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common')
\eqn{^{40}}Ar/\eqn{^{36}}Ar, \eqn{^{40}}Ca/\eqn{^{44}}Ca,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd,
\eqn{^{187}}Os/\eqn{^{188}}Os or \eqn{^{176}}Hf/\eqn{^{177}}Hf
ratio from an isochron fit. Setting \code{i2i} to \code{FALSE}
uses the default values stored in
\code{settings('iratio',...)}. When applied to data of class
\code{ThU}, setting \code{i2i} to \code{TRUE} applies a
detrital Th-correction.}

\item{detritus}{detrital \eqn{^{230}}Th correction (only applicable
    when \code{x$format == 1} or \code{2}.

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus.

\code{3}: correct the data using the measured present day
\eqn{^{230}}Th/\eqn{^{238}}U, \eqn{^{232}}Th/\eqn{^{238}}U and
\eqn{^{234}}U/\eqn{^{238}}U-ratios in the detritus.}
}
\value{
Returns a list with the following items:

\describe{

\item{peaks}{a \code{3 x k} matrix with the following rows:

\code{t}: the ages of the \code{k} peaks

\code{s[t]}: the estimated uncertainties of \code{t}

\code{ci[t]}: the widths of approximate \eqn{100(1-\alpha)\%}
confidence intervals for \code{t}}

\item{props}{a \code{2 x k} matrix with the following rows:

\code{p}: the proportions of the \code{k} peaks

\code{s[p]}: the estimated uncertainties (standard errors) of
\code{p}}

\item{L}{the log-likelihood of the fit}

\item{legend}{a vector of text expressions to be used in a figure
    legend}

}
}
\description{
Implements the discrete mixture modelling algorithms of Galbraith
and Laslett (1993) and applies them to fission track and other
geochronological datasets.
}
\details{
Consider a dataset of \eqn{n} dates \eqn{\{t_1, t_2, ..., t_n\}}
with analytical uncertainties \eqn{\{s[t_1], s[t_2], ...,
s[t_n]\}}.  Define \eqn{z_i = \log(t_i)} and \eqn{s[z_i] =
s[t_i]/t_i}.  Suppose that these \eqn{n} values are derived from a
mixture of \eqn{k>2} populations with means
\eqn{\{\mu_1,...,\mu_k\}}. Such a \emph{discrete mixture} may be
mathematically described by:
\eqn{P(z_i|\mu,\omega) = \sum_{j=1}^k \pi_j N(z_i | \mu_j, s[z_j]^2 )}
where \eqn{\pi_j} is the proportion of the population that belongs
to the \eqn{j^{th}} component, and
\eqn{\pi_k=1-\sum_{j=1}^{k-1}\pi_j}. This equation can be solved by
the method of maximum likelihood (Galbraith and Laslett, 1993).
\code{IsoplotR} implements the Bayes Information Criterion (BIC) as
a means of automatically choosing \eqn{k}. This option should be
used with caution, as the number of peaks steadily rises with
sample size (\eqn{n}).  If one is mainly interested in the youngest
age component, then it is more productive to use an alternative
parameterisation, in which all grains are assumed to come from one
of two components, whereby the first component is a single discrete
age peak (\eqn{\exp(m)}, say) and the second component is a
continuous distribution (as descibed by the \code{\link{central}}
age model), but truncated at this discrete value (Van der Touw et
al., 1997).
}
\examples{
data(examples)
peakfit(examples$FT1,k=2)

peakfit(examples$LudwigMixture,k='min')
}
\references{
Galbraith, R.F. and Laslett, G.M., 1993. Statistical models for
mixed fission track ages. Nuclear Tracks and Radiation
Measurements, 21(4), pp.459-470.

van der Touw, J., Galbraith, R., and Laslett, G. A logistic
truncated normal mixture model for overdispersed binomial
data. Journal of Statistical Computation and Simulation,
59(4):349-373, 1997.
}
\seealso{
\code{\link{radialplot}}, \code{\link{central}}
}
