% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/central.R
\name{central}
\alias{central}
\alias{central.UThHe}
\alias{central.default}
\alias{central.fissiontracks}
\title{Calculate U-Th-He (and fission track) central ages and compositions}
\usage{
central(x, ...)

\method{central}{default}(x, ...)

\method{central}{UThHe}(x, ...)

\method{central}{fissiontracks}(x, mineral = NA, ...)
}
\arguments{
\item{x}{an object of class \code{UThHe} or \code{fissiontracks}}

\item{...}{optional arguments}

\item{mineral}{setting this parameter to either \code{apatite} or
\code{zircon} changes the default efficiency factor, initial
fission track length and density to preset values (only affects
results if \code{x$format = 2}.)}
}
\value{
a list containing the following items:

\describe{

\item{mswd}{the reduced Chi-square statistic of data concordance,
i.e. mswd = SS/(2n-2) where, SS is the sum of squares of the
log[U/He]-log[Th/He] compositions and n is the number of
samples. If \code{x} has class \code{fissiontracks}, then mswd =
X2/(n-1), where X2 is a Chi-square statistic of the EDM data or ICP
ages.}

\item{p.value}{the p-value of a Chi-square test with n-2 degrees of
freedom}

\item{age}{a two-column vector with the central age and its
standard error.}

}

Additionally, if \code{x} has class \code{UThHe}:

\describe{

\item{uvw}{(if the input data table contains Sm) or \strong{uv} (if
it doesn't): the geometric mean log[U/He], log[Th/He] (,
log[Sm/He]) and log[Sm/He] composition}

\item{covmat}{the covariance matrix of \code{uvw} or \code{uv}}

}

OR, if \code{x} has class \code{fissiontracks}:

\describe{

\item{disp}{the (over)dispersion of the ages (value between 0 and
1)}

}
}
\description{
Computes the geometric mean composition of a set of fission track
or U-Th-He data and returns the corresponding age and fitting
parameters.
}
\examples{
data(examples)
print(central(examples$UThHe)$age)
}

