\name{plot.InvariantCausalPrediction}
\alias{plot.InvariantCausalPrediction}
\title{
Plots of "InvariantCausalPrediction" objects
}
\description{
Plots confidence intervals for invariant causal prediction (output of \code{\link{ICP}} function)
}
\usage{
\method{plot}{InvariantCausalPrediction}(x, 
                 maxshow = 50, col1 = NULL, col2 = NULL, col3 = NULL, 
                 mar = c(10, 4, 3, 1), lwd = 1, ...)
}
\arguments{
  \item{x}{
Object of class "InvariantCausalPrediction", as generated by function \code{\link{ICP}}.
}
  \item{maxshow}{
Maximal number of variables to show confidence intervals for
}
  \item{col1}{
Colour of confidence intervals generated by accepted sets of variables (defaults to light red).
}
  \item{col2}{
Colour of point-estimates generated by accepted sets of variables (defaults to light red).
}
  \item{col3}{
Colour of confidence intervals generated by procedure (defaults to blue).
}
  \item{mar}{
Margins for the figure (might need to be adjusted to allow for long variable names.
}
  \item{lwd}{
Scaling of the width of the lines used for individual confidence intervals.
}
  \item{\dots}{
Additional inputs to generic \code{plot} function (not used).
}
}
\value{
Does not return an object.
}
\references{
Jonas Peters, Peter Buhlmann, Nicolai Meinshausen (2015):

 Causal inference using invariant prediction: identification and confidence intervals

 arxiv preprint \url{http://arxiv.org/abs/1501.01332}
}
\author{
Nicolai Meinshausen <meinshausen@stat.math.ethz.ch>
}
\seealso{
\code{\link{ICP}}
}

\keyword{Causality }
\keyword{Regression }
\keyword{Classification }

