% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlausibleFormula.R
\name{PlausibleFormula}
\alias{PlausibleFormula}
\title{PlausibleFormula.}
\usage{
PlausibleFormula(x, ruleset = c("GCMS", "LCMS")[1])
}
\arguments{
\item{x}{A chemical formula. No validity checks are performed.}

\item{ruleset}{Currently either "GCMS" or "LCMS" as a keyword. In future potentially a link to a texfile containing the ruleset.}
}
\value{
Either TRUE or FALSE. Use sapply(vector, PlausibleFormula) if necessary.
}
\description{
\code{PlausibleFormula} will count the chemical elements within a provided formula and apply a rule set to evaluate if this formula is plausible.
It is currently exported to allow the user to modify/substitute the result but may become an internal function in the future.
}
\details{
The rules are developed based on comparison with ~1000 compounds found in the Golm Metabolome Database (GMD) for silylated metabolites detectable in GC-MS.
The following elements will be counted and tested: c("C","H","N","O","P","S","Si").
}
\examples{
PlausibleFormula(x="C6H12O6")
PlausibleFormula(x="C5H13O14P3")

}
\keyword{internal}

