% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_RunIntLim.R
\name{RunIntLim}
\alias{RunIntLim}
\title{Run linear models and retrieve relevant statistics}
\usage{
RunIntLim(
  inputData,
  stype = "",
  outcome = 1,
  covar = c(),
  continuous = FALSE,
  save.covar.pvals = FALSE,
  independent.var.type = 1,
  remove.duplicates = FALSE,
  suppressWarnings = FALSE
)
}
\arguments{
\item{inputData}{Named list (output of 
FilterData()) with analyte abundances, 
and associated meta-data}

\item{stype}{column name that represents sample type (by default, it will be used
in the interaction term). Only 2 categories are currently supported.}

\item{outcome}{'1' or '2' must be set as outcome/independent variable
(default is '1')}

\item{covar}{Additional variables from the phenotypic data that be integrated into linear model}

\item{continuous}{boolean to indicate whether the data is continuous or discrete}

\item{save.covar.pvals}{boolean to indicate whether or not to save the p-values of all covariates,
which can be analyzed later but will also lengthen computation time. The default is FALSE.}

\item{independent.var.type}{'1' or '2' must be set as independent variable
(default is '1')}

\item{remove.duplicates}{boolean to indicate whether or not to remove the 
pair with the highest p-value across two duplicate models (e.g. m1~m2 and m2~m1)}

\item{suppressWarnings}{whether or not to print warnings. If TRUE, do not print.}
}
\value{
IntLimResults object with model results
}
\description{
Run linear models and retrieve relevant statistics
}
