% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalfunctions.R
\name{FilterDataFolds}
\alias{FilterDataFolds}
\title{Filter input data by abundance values (analyte data) and number of missing 
values.}
\usage{
FilterDataFolds(
  inputDataFolds,
  analyteType1perc = 0,
  analyteType2perc = 0,
  analyteMiss = 0,
  cov.cutoff = 0,
  suppressWarnings = FALSE
)
}
\arguments{
\item{inputDataFolds}{List of IntLimData objects (output of ReadData()) with analylte levels and
associated meta-data}

\item{analyteType1perc}{percentile cutoff (0-1) for filtering analyte type 1 (e.g. 
remove analytes with mean values < 'analyteType1perc' percentile) (default: 0)}

\item{analyteType2perc}{percentile cutoff (0-1) for filtering analyte type 2 
(default: no filtering of analytes) (default:0)}

\item{analyteMiss}{missing value percent cutoff (0-1) for filtering analytes 
(analytes with > 80\% missing values will be removed) (default:0)}

\item{cov.cutoff}{percentile cutoff (0-1) for the covariances of the anaytes (default: 0.30)}

\item{suppressWarnings}{whether to suppress warnings}
}
\value{
filtData IntLimData object with input data after filtering
}
\description{
Filter data by abundance (with user-input percentile cutoff) of missing values 
(with user-input percent cutoff). Missing values are commonly found in 
metabolomics data.
}
