/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;

public class SparseRCMFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFComplexMatrix1D[] elements;

    public SparseRCMFComplexMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseFComplexMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = new SparseFComplexMatrix1D(n2);
        }
    }

    public SparseFComplexMatrix1D[] elements() {
        return this.elements;
    }

    public float[] getQuick(int n, int n2) {
        return this.elements[n].getQuick(n2);
    }

    public void setQuick(int n, int n2, float[] fArray) {
        this.elements[n].setQuick(n2, fArray);
    }

    public void setQuick(int n, int n2, float f, float f2) {
        this.elements[n].setQuick(n2, f, f2);
    }

    public void trimToSize() {
        for (int i = 0; i < this.rows; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseFComplexMatrix1D viewRow(int n) {
        return this.elements[n];
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new SparseRCMFComplexMatrix2D(n, n2);
    }
}

