% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBootstrap.R
\name{read_bootstrap}
\alias{read_bootstrap}
\title{Read individual bootstrap binary file}
\usage{
read_bootstrap(file_name, nX = 304, nY = 448)
}
\arguments{
\item{file_name}{file name for binary bootstrap data}

\item{nX}{dimension in the x (defaults to value for Northern Polar
stereographic grid: 304)}

\item{nY}{dimension in the y (defaults to value for Northern Polar
stereographic grid: 448)}
}
\value{
numeric vector of concentrations
}
\description{
Read in individual binary files of monthly observation data. The observations
are from the monthly sea ice concentration obtained from the National
Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm.
The results are distributed by the National Snow and Ice Data Center (NSIDC)
(Comiso 2017). Functions assume file name conventions are the
same as used by NSIDC.
}
\examples{
\dontrun{
#fileName should be the binary file
rawData <- read_bootstrap(file_name)
}
}
\references{
Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center.
            doi: \url{https://doi.org/10.5067/7Q8HCCWS4I0R}
}
